import React, { SVGAttributes, forwardRef } from 'react';

export interface ErrorOutlineProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const ErrorOutline = forwardRef<SVGSVGElement, ErrorOutlineProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12ZM20 12C20 16.4183 16.4183 20 12 20C7.58172 20 4 16.4183 4 12C4 7.58172 7.58172 4 12 4C16.4183 4 20 7.58172 20 12ZM10.75 16.2428C10.75 15.5202 11.2991 15 11.9928 15C12.7009 15 13.25 15.5202 13.25 16.2428C13.25 16.9653 12.7009 17.5 11.9928 17.5C11.2991 17.5 10.75 16.9653 10.75 16.2428ZM11.3223 6C11.0376 6 10.8103 6.23741 10.8228 6.52185L11.129 13.5219C11.1407 13.7892 11.3609 14 11.6285 14H12.3713C12.639 14 12.8591 13.7892 12.8708 13.5219L13.1771 6.52185C13.1895 6.23741 12.9623 6 12.6776 6H11.3223Z"
        fill="currentColor"
      />
    </svg>
  );
});
