import React, { SVGAttributes, forwardRef } from 'react';

export interface FamilyCardLockedProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const FamilyCardLocked = forwardRef<SVGSVGElement, FamilyCardLockedProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M0 8.4C0 6.15979 0 5.03969 0.435974 4.18404C0.819467 3.43139 1.43139 2.81947 2.18404 2.43597C3.03969 2 4.15979 2 6.4 2H13.6C15.8402 2 16.9603 2 17.816 2.43597C18.5686 2.81947 19.1805 3.43139 19.564 4.18404C20 5.03969 20 6.15979 20 8.4V9.20703C19.5232 9.07217 19.02 9 18.5 9C18.3315 9 18.1647 9.00758 18 9.02242V7.2C18 6.0799 18 5.51984 17.782 5.09202C17.5903 4.71569 17.2843 4.40973 16.908 4.21799C16.4802 4 15.9201 4 14.8 4H5.2C4.0799 4 3.51984 4 3.09202 4.21799C2.71569 4.40973 2.40973 4.71569 2.21799 5.09202C2 5.51984 2 6.0799 2 7.2V12.8C2 13.9201 2 14.4802 2.21799 14.908C2.40973 15.2843 2.71569 15.5903 3.09202 15.782C3.51984 16 4.0799 16 5.2 16H11.5351C11.1948 16.5883 11 17.2714 11 18H6.4C4.15979 18 3.03969 18 2.18404 17.564C1.43139 17.1805 0.819467 16.5686 0.435974 15.816C0 14.9603 0 13.8402 0 11.6V8.4ZM6.10352 9.1046C6.10352 10.9362 8.7377 12.8698 9.6743 13.4995C9.87314 13.6331 10.1268 13.6331 10.3256 13.4995C11.2622 12.8698 13.8964 10.9362 13.8964 9.1046C13.8964 6.57214 10.8377 6.16649 9.99995 7.87249C9.16222 6.16649 6.10352 6.57214 6.10352 9.1046ZM18.5 11C16.567 11 15 12.567 15 14.5V17C13.8954 17 13 17.8954 13 19V22C13 23.1046 13.8954 24 15 24H22C23.1046 24 24 23.1046 24 22V19C24 17.8954 23.1046 17 22 17V14.5C22 12.567 20.433 11 18.5 11ZM20 14.5V17H17V14.5C17 13.6716 17.6716 13 18.5 13C19.3284 13 20 13.6716 20 14.5Z"
        fill="currentColor"
      />
    </svg>
  );
});
