import React, { SVGAttributes, forwardRef } from 'react';

export interface FamilyCardOutlineProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const FamilyCardOutline = forwardRef<SVGSVGElement, FamilyCardOutlineProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M2 10.4C2 8.15979 2 7.03969 2.43597 6.18404C2.81947 5.43139 3.43139 4.81947 4.18404 4.43597C5.03969 4 6.15979 4 8.4 4H15.6C17.8402 4 18.9603 4 19.816 4.43597C20.5686 4.81947 21.1805 5.43139 21.564 6.18404C22 7.03969 22 8.15979 22 10.4V13.6C22 15.8402 22 16.9603 21.564 17.816C21.1805 18.5686 20.5686 19.1805 19.816 19.564C18.9603 20 17.8402 20 15.6 20H8.4C6.15979 20 5.03969 20 4.18404 19.564C3.43139 19.1805 2.81947 18.5686 2.43597 17.816C2 16.9603 2 15.8402 2 13.6V10.4ZM4 9.2C4 8.0799 4 7.51984 4.21799 7.09202C4.40973 6.71569 4.71569 6.40973 5.09202 6.21799C5.51984 6 6.0799 6 7.2 6H16.8C17.9201 6 18.4802 6 18.908 6.21799C19.2843 6.40973 19.5903 6.71569 19.782 7.09202C20 7.51984 20 8.0799 20 9.2V14.8C20 15.9201 20 16.4802 19.782 16.908C19.5903 17.2843 19.2843 17.5903 18.908 17.782C18.4802 18 17.9201 18 16.8 18H7.2C6.0799 18 5.51984 18 5.09202 17.782C4.71569 17.5903 4.40973 17.2843 4.21799 16.908C4 16.4802 4 15.9201 4 14.8V9.2ZM8.10352 11.1046C8.10352 12.9362 10.7377 14.8698 11.6743 15.4995C11.8731 15.6331 12.1268 15.6331 12.3256 15.4995C13.2622 14.8698 15.8964 12.9362 15.8964 11.1046C15.8964 8.57214 12.8377 8.16649 12 9.87249C11.1622 8.16649 8.10352 8.57214 8.10352 11.1046Z"
        fill="currentColor"
      />
    </svg>
  );
});
