import React, { SVGAttributes, forwardRef } from 'react';

export interface HeartBrokenProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const HeartBroken = forwardRef<SVGSVGElement, HeartBrokenProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M16.5063 18.142C15.3524 19.0618 14.0191 19.9677 12.5089 20.8604C12.195 21.046 11.805 21.046 11.4911 20.8604C5.21867 17.1527 2 13.2188 2 8.99957C2 8.76155 2.01061 8.52999 2.0312 8.30502L4.10944 10.1523C4.65568 13.0301 7.25146 15.936 12 18.8332C13.1197 18.15 14.1197 17.4664 15.0014 16.7827C12.8222 14.8234 10.4511 12.7267 8.30249 10.839C6.18549 8.97915 4.2722 7.31161 2.98328 6.18825L2.98305 6.18805C2.02175 5.35022 1.40781 4.81513 1.31576 4.72877C0.913005 4.35088 0.892851 3.71803 1.27075 3.31527C1.64864 2.91252 2.28149 2.89236 2.68424 3.27026C2.68399 3.27002 2.684 3.27003 2.68431 3.27031L2.68432 3.27032L2.69674 3.28161L2.73471 3.31555C2.76682 3.3441 2.80994 3.38216 2.86413 3.42978C2.97236 3.5249 3.12105 3.65494 3.30661 3.8169C3.48594 3.97342 3.69876 4.15895 3.94146 4.37046C6.18888 2.3937 9.85536 2.46866 12 5.10169C15.2512 1.11005 22 2.99742 22 8.99957C22 11.1609 21.1554 13.2474 19.4883 15.2669L17.9924 13.9372C19.3372 12.2851 20 10.637 20 8.99957C20 4.54079 14.6772 3.50982 12.911 7.41193C12.5564 8.19545 11.4436 8.19545 11.089 7.41193C9.91954 4.82828 7.19093 4.40728 5.48052 5.71199C6.63883 6.72227 8.07166 7.97403 9.62252 9.33653C13.3429 12.6051 17.7542 16.5211 20.6842 19.2703C21.087 19.6482 21.1072 20.281 20.7293 20.6838C20.3514 21.0865 19.7185 21.1067 19.3158 20.7288C18.4842 19.9486 17.5309 19.0722 16.5063 18.142Z"
        fill="currentColor"
      />
    </svg>
  );
});
