import React, { SVGAttributes, forwardRef } from 'react';

export interface HomeProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Home = forwardRef<SVGSVGElement, HomeProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M10.5858 2.5C11.3668 1.71895 12.6332 1.71895 13.4142 2.5L22.3536 11.4393C23.2985 12.3843 22.6292 14 21.2929 14H20V20C20 21.1046 19.1046 22 18 22H15C13.8954 22 13 21.1046 13 20V16C13 15.4477 12.5523 15 12 15C11.4477 15 11 15.4477 11 16V20C11 21.1046 10.1046 22 9 22H6C4.89543 22 4 21.1046 4 20V14H2.70711C1.37075 14 0.701501 12.3843 1.64645 11.4393L10.5858 2.5ZM3.91421 12H6V20H9V16C9 14.3431 10.3431 13 12 13C13.6569 13 15 14.3431 15 16V20H18V12H20.0858L12 3.91422L3.91421 12Z"
        fill="currentColor"
      />
    </svg>
  );
});
