import React, { SVGAttributes, forwardRef } from 'react';

export interface IdOutlineProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const IdOutline = forwardRef<SVGSVGElement, IdOutlineProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M13.1099 2.06083C12.5609 2.00015 12.0667 2.39596 12.0061 2.9449C11.9454 3.49384 12.3412 3.98804 12.8901 4.04872C15.7206 4.36162 18.1098 6.15381 19.262 8.63869C19.4944 9.13973 20.0889 9.35755 20.5899 9.12521C21.091 8.89288 21.3088 8.29836 21.0765 7.79732C19.638 4.69526 16.655 2.45273 13.1099 2.06083ZM8.71328 4.70375C9.21668 4.47658 9.44061 3.88434 9.21344 3.38094C8.98627 2.87754 8.39403 2.65361 7.89062 2.88078C4.41929 4.44728 2 7.93997 2 11.9998C2 17.5227 6.47715 21.9998 12 21.9998C17.148 21.9998 21.3862 18.1107 21.939 13.1097C21.9997 12.5608 21.6039 12.0666 21.0549 12.0059C20.506 11.9452 20.0118 12.341 19.9511 12.89C19.5091 16.8889 16.1172 19.9998 12 19.9998C7.58172 19.9998 4 16.4181 4 11.9998C4 8.75471 5.93228 5.95874 8.71328 4.70375ZM8.79949 14.3997C8.46775 13.9581 7.84087 13.8691 7.39932 14.2008C6.95777 14.5326 6.86876 15.1595 7.2005 15.601C8.29348 17.0558 10.0366 17.9998 12 17.9998C13.9634 17.9998 15.7065 17.0558 16.7995 15.601C17.1312 15.1595 17.0422 14.5326 16.6007 14.2008C16.1591 13.8691 15.5322 13.9581 15.2005 14.3997C14.469 15.3732 13.3078 15.9998 12 15.9998C10.6922 15.9998 9.53097 15.3732 8.79949 14.3997Z"
        fill="currentColor"
      />
    </svg>
  );
});
