import React, { SVGAttributes, forwardRef } from 'react';

export interface KeyProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Key = forwardRef<SVGSVGElement, KeyProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        d="M10.5 5.99902C9.94772 5.99902 9.5 6.44674 9.5 6.99902C9.5 7.55131 9.94772 7.99902 10.5 7.99902H13.5C14.0523 7.99902 14.5 7.55131 14.5 6.99902C14.5 6.44674 14.0523 5.99902 13.5 5.99902H10.5Z"
        fill="currentColor"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M8.5 13.9639C6.722 13.7273 5.28991 12.3185 5.062 10.4952L4.562 6.49516C4.26357 4.10775 6.12511 1.99902 8.53111 1.99902H15.4688C17.8748 1.99902 19.7364 4.10775 19.438 6.49516L18.938 10.4952C18.7101 12.3184 17.278 13.7272 15.5 13.9639V21.1657L12 22.999L8.5 21.1657V13.9639ZM8.53111 3.99902H15.4688C16.6718 3.99902 17.6026 5.05339 17.4534 6.24709L16.9534 10.2471C16.8283 11.248 15.9775 11.999 14.9688 11.999H14.5C13.9477 11.999 13.5 12.4467 13.5 12.999V19.9555L12 20.7413L10.5 19.9555V12.999C10.5 12.4467 10.0523 11.999 9.5 11.999H9.03111C8.02246 11.999 7.17166 11.248 7.04655 10.2471L6.54655 6.24709C6.39734 5.05339 7.32811 3.99902 8.53111 3.99902Z"
        fill="currentColor"
      />
    </svg>
  );
});
