import React, { SVGAttributes, forwardRef } from 'react';

export interface KeyNotificationProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const KeyNotification = forwardRef<SVGSVGElement, KeyNotificationProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M6 13.9649C3.2729 13.8312 2.28966 12.3194 2.06175 10.4961L1.56175 6.49614C1.26332 4.10873 3.12487 2 5.53086 2H12.4686C14.8746 2 16.7361 4.10873 16.4377 6.49614L15.9996 10.001H13.984L14.4532 6.24807C14.6024 5.05436 13.6716 4 12.4686 4H5.53086C4.32787 4 3.39709 5.05436 3.54631 6.24807L4.04631 10.2481C4.17141 11.2489 5.02222 12 6.03086 12H7C7.55228 12 8 12.4477 8 13V19.9565L9 20.4803V22.7381L6 21.1667V13.9649ZM7.49976 6C6.94747 6 6.49976 6.44772 6.49976 7C6.49976 7.55228 6.94747 8 7.49976 8H10.4998C11.052 8 11.4998 7.55228 11.4998 7C11.4998 6.44772 11.052 6 10.4998 6H7.49976ZM10 14.001C10 12.8964 10.8954 12.001 12 12.001H21C22.1046 12.001 23 12.8964 23 14.001V19.001C23 20.1055 22.1046 21.001 21 21.001H17L13.8 23.401C13.4704 23.6482 13 23.413 13 23.001V21.001H12C10.8954 21.001 10 20.1055 10 19.001V14.001ZM12 14.001H21V19.001H16.6L14.5 20.501V19.501C14.5 19.2248 14.2761 19.001 14 19.001H13H12V14.001Z"
        fill="currentColor"
      />
    </svg>
  );
});
