import React, { SVGAttributes, forwardRef } from 'react';

export interface KeyPlusProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const KeyPlus = forwardRef<SVGSVGElement, KeyPlusProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M6 13.9639C3.2729 13.8302 2.28966 12.3185 2.06175 10.4952L1.56175 6.49516C1.26332 4.10775 3.12487 1.99902 5.53086 1.99902H12.4686C14.8746 1.99902 16.7361 4.10775 16.4377 6.49516L16.2457 8.03116C15.5292 8.09061 14.8366 8.23399 14.1776 8.45143L14.4532 6.24709C14.6024 5.05339 13.6716 3.99902 12.4686 3.99902H5.53086C4.32787 3.99902 3.39709 5.05339 3.54631 6.24709L4.04631 10.2471C4.17141 11.248 5.02222 11.999 6.03086 11.999H7C7.55228 11.999 8 12.4467 8 12.999V17V19.9555L8.6156 20.278C8.95849 21.1544 9.43482 21.9639 10.0196 22.6815L9.5 22.999L6 21.1657V13.9639ZM7.49976 5.99902C6.94747 5.99902 6.49976 6.44674 6.49976 6.99902C6.49976 7.55131 6.94747 7.99902 7.49976 7.99902H10.4998C11.052 7.99902 11.4998 7.55131 11.4998 6.99902C11.4998 6.44674 11.052 5.99902 10.4998 5.99902H7.49976ZM17 12C14.2386 12 12 14.2386 12 17C12 19.7614 14.2386 22 17 22C19.7614 22 22 19.7614 22 17C22 14.2386 19.7614 12 17 12ZM10 17C10 13.134 13.134 10 17 10C20.866 10 24 13.134 24 17C24 20.866 20.866 24 17 24C13.134 24 10 20.866 10 17ZM17 13.5C16.4477 13.5 16 13.9477 16 14.5V16H14.5C13.9477 16 13.5 16.4477 13.5 17C13.5 17.5523 13.9477 18 14.5 18H16V19.5C16 20.0523 16.4477 20.5 17 20.5C17.5523 20.5 18 20.0523 18 19.5V18H19.5C20.0523 18 20.5 17.5523 20.5 17C20.5 16.4477 20.0523 16 19.5 16H18V14.5C18 13.9477 17.5523 13.5 17 13.5Z"
        fill="currentColor"
      />
    </svg>
  );
});
