import React, { SVGAttributes, forwardRef } from 'react';

export interface KeyRefreshProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const KeyRefresh = forwardRef<SVGSVGElement, KeyRefreshProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M2.06175 10.4952C2.28966 12.3185 3.2729 13.8302 6 13.9639V21.1657L8.89384 22.6815L8 20V19.9555V19.5V17V12.999C8 12.4467 7.55228 11.999 7 11.999H6.03086C5.02222 11.999 4.17141 11.248 4.04631 10.2471L3.54631 6.24709C3.39709 5.05339 4.32787 3.99902 5.53086 3.99902H12.4686C13.6716 3.99902 14.6024 5.05339 14.4532 6.24709L14.1776 8.45143C14.8366 8.23399 15.5292 8.09061 16.2457 8.03116L16.4377 6.49516C16.7361 4.10775 14.8746 1.99902 12.4686 1.99902H5.53086C3.12487 1.99902 1.26332 4.10775 1.56175 6.49516L2.06175 10.4952ZM6.49976 6.99902C6.49976 6.44674 6.94747 5.99902 7.49976 5.99902H10.4998C11.052 5.99902 11.4998 6.44674 11.4998 6.99902C11.4998 7.55131 11.052 7.99902 10.4998 7.99902H7.49976C6.94747 7.99902 6.49976 7.55131 6.49976 6.99902ZM13.3324 15.4004C13.9506 13.9856 15.3613 13 17 13C17.9209 13 18.768 13.3103 19.4444 13.8334L18.7773 14.834C18.4451 15.3324 18.8024 16 19.4014 16H22.9594C23.4713 16 23.8328 15.4985 23.6709 15.0128L22.4849 11.4548C22.2876 10.8627 21.4956 10.7566 21.1494 11.2759L20.5556 12.1666C19.5608 11.4339 18.3305 11 17 11C14.5381 11 12.4246 12.4826 11.4997 14.5996C11.2786 15.1057 11.5096 15.6952 12.0157 15.9164C12.5218 16.1375 13.1113 15.9065 13.3324 15.4004ZM22.5003 19.4004C22.7214 18.8943 22.4904 18.3048 21.9843 18.0836C21.4782 17.8625 20.8887 18.0935 20.6676 18.5996C20.0494 20.0144 18.6387 21 17 21C16.079 21 15.232 20.6897 14.5556 20.1666L15.2226 19.166C15.5549 18.6676 15.1976 18 14.5986 18H11.0406C10.5287 18 10.1672 18.5015 10.3291 18.9872L11.5151 22.5452C11.7124 23.1373 12.5044 23.2434 12.8506 22.7241L13.4444 21.8334C14.4392 22.5661 15.6696 23 17 23C19.4619 23 21.5754 21.5174 22.5003 19.4004Z"
        fill="currentColor"
      />
    </svg>
  );
});
