import React, { SVGAttributes, forwardRef } from 'react';

export interface KeyShieldProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const KeyShield = forwardRef<SVGSVGElement, KeyShieldProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M6 13.9639C3.2729 13.8302 2.28966 12.3185 2.06175 10.4952L1.56175 6.49516C1.26332 4.10775 3.12487 1.99902 5.53086 1.99902H12.4686C14.8746 1.99902 16.7361 4.10775 16.4377 6.49516L15.9589 10.3253L13.6778 11.0382C13.8208 10.8032 13.9171 10.5355 13.9532 10.2471L14.4532 6.24709C14.6024 5.05339 13.6716 3.99902 12.4686 3.99902H5.53086C4.32787 3.99902 3.39709 5.05339 3.54631 6.24709L4.04631 10.2471C4.17141 11.248 5.02222 11.999 6.03086 11.999H7C7.55228 11.999 8 12.4467 8 12.999V19.9555L9.5 20.7413L10.0695 20.2937C10.3206 20.8993 10.627 21.4775 11.0002 22H11.1346L9.5 22.999L6 21.1657V13.9639ZM7.49976 5.99902C6.94747 5.99902 6.49976 6.44674 6.49976 6.99902C6.49976 7.55131 6.94747 7.99902 7.49976 7.99902H10.4998C11.052 7.99902 11.4998 7.55131 11.4998 6.99902C11.4998 6.44674 11.052 5.99902 10.4998 5.99902H7.49976ZM17 14.1082L13.0203 15.4348C13.0635 16.5788 13.1982 17.7634 13.6151 18.8405C14.1122 20.1247 15.0241 21.2978 17.001 21.9232C18.9957 21.2969 19.8985 20.1475 20.3876 18.8981C20.8086 17.8226 20.9405 16.6267 20.9816 15.4354L17 14.1082ZM11 14C11 17 11 22.5 17 24.0001C23 22.5 23 17.1722 23 14L17 12L11 14Z"
        fill="currentColor"
      />
    </svg>
  );
});
