import React, { SVGAttributes, forwardRef } from 'react';

export interface KeysProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Keys = forwardRef<SVGSVGElement, KeysProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M16 10.4149V11.8293V17.7639L18 16.7639L18 11.8293V10.4149L19.3335 9.94361C19.7246 9.80538 20 9.43228 20 9V6C20 5.44772 19.5523 5 19 5L15 5C14.4477 5 14 5.44772 14 6V9C14 9.43228 14.2754 9.80538 14.6665 9.94361L16 10.4149ZM15.4472 20.2764L19.4472 18.2764C19.786 18.107 20 17.7607 20 17.382V11.8293C21.1652 11.4175 22 10.3062 22 9V6C22 4.34315 20.6569 3 19 3H15C13.3431 3 12 4.34315 12 6V9C12 10.3062 12.8348 11.4175 14 11.8293V19.382C14 20.1253 14.7823 20.6088 15.4472 20.2764ZM18.5 7C18.5 7.55228 18.0523 8 17.5 8H16.5C15.9477 8 15.5 7.55228 15.5 7C15.5 6.44772 15.9477 6 16.5 6H17.5C18.0523 6 18.5 6.44772 18.5 7ZM6 13.5851L6 12.1707L6 7.23607L8 6.23606L8 12.1707V13.5851L9.33351 14.0564C9.7246 14.1946 10 14.5677 10 15V18C10 18.5523 9.55228 19 9 19H5C4.44772 19 4 18.5523 4 18V15C4 14.5677 4.2754 14.1946 4.66649 14.0564L6 13.5851ZM8.55278 3.7236L4.55279 5.72361C4.214 5.893 4 6.23926 4 6.61803L4 12.1707C2.83481 12.5825 2 13.6938 2 15V18C2 19.6569 3.34315 21 5 21H9C10.6569 21 12 19.6569 12 18V15C12 13.6938 11.1652 12.5825 10 12.1707L10 4.61803C10 3.87465 9.21769 3.39115 8.55278 3.7236ZM8.5 17C8.5 16.4477 8.05228 16 7.5 16H6.5C5.94772 16 5.5 16.4477 5.5 17C5.5 17.5523 5.94772 18 6.5 18H7.5C8.05229 18 8.5 17.5523 8.5 17Z"
        fill="currentColor"
      />
    </svg>
  );
});
