import React, { SVGAttributes, forwardRef } from 'react';

export interface KvkoProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Kvko = forwardRef<SVGSVGElement, KvkoProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M20 7.40811L12 2.80811L4 7.40811L4 16.594L12 21.194L20 16.594L20 7.40811ZM12.9969 1.07429C12.3797 0.719377 11.6203 0.719376 11.0031 1.07429L3.00306 5.67429C2.38253 6.0311 2 6.69231 2 7.40811V16.594C2 17.3098 2.38253 17.971 3.00306 18.3278L11.0031 22.9278C11.6203 23.2827 12.3797 23.2827 12.9969 22.9278L20.9969 18.3278C21.6175 17.971 22 17.3098 22 16.594V7.40811C22 6.69231 21.6175 6.0311 20.9969 5.67429L12.9969 1.07429ZM10.75 16.2438C10.75 15.5213 11.2991 15.001 11.9928 15.001C12.7009 15.001 13.25 15.5213 13.25 16.2438C13.25 16.9664 12.7009 17.501 11.9928 17.501C11.2991 17.501 10.75 16.9664 10.75 16.2438ZM12.2248 6.50104C10.0678 6.50104 8.44995 7.74436 8.44995 9.75165V9.77594C8.44995 10.0521 8.67381 10.2759 8.94995 10.2759H9.75319C9.99311 10.2759 10.1876 10.0814 10.1876 9.84152C10.1876 8.71804 11.0564 8.11885 12.2248 8.11885C13.3633 8.11885 14.1123 8.71804 14.1123 9.57189C14.1123 10.3808 13.6929 10.7553 12.6443 11.2346L12.3447 11.3695C11.4609 11.7589 11.1313 12.3431 11.1313 13.3618V13.501C11.1313 13.7772 11.3552 14.001 11.6313 14.001H12.369C12.6451 14.001 12.869 13.7772 12.869 13.501V13.4666C12.869 13.0172 12.9888 12.8375 13.3483 12.6727L13.6479 12.5379C14.9062 11.9686 15.85 11.2197 15.85 9.58687V9.49699C15.85 7.77432 14.352 6.50104 12.2248 6.50104Z"
        fill="currentColor"
      />
    </svg>
  );
});
