import React, { SVGAttributes, forwardRef } from 'react';

export interface LoginProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Login = forwardRef<SVGSVGElement, LoginProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M13.1003 2.00505L12.1053 1.90479L11.9048 3.89471L12.8997 3.99497C15.3907 4.246 17.5486 5.67795 18.8138 7.74473L19.3359 8.59761L21.0417 7.55338L20.5195 6.70051C18.9434 4.12582 16.242 2.32167 13.1003 2.00505ZM8.96095 4.62034L9.8751 4.21494L9.0643 2.38666L8.15016 2.79206C6.57335 3.49133 5.21381 4.59384 4.19624 5.96854C3.86766 6.41245 3.96114 7.03867 4.40505 7.36726C4.84895 7.69584 5.47518 7.60235 5.80376 7.15845C6.61951 6.0564 7.70665 5.17659 8.96095 4.62034ZM22 11.9777V10.9777H20V11.9777C20 16.4224 16.454 20 12.1111 20C9.53732 20 7.24725 18.7471 5.80376 16.797C5.47518 16.3531 4.84895 16.2596 4.40505 16.5882C3.96114 16.9168 3.86766 17.543 4.19624 17.9869C5.99623 20.4187 8.86943 22 12.1111 22C17.5866 22 22 17.4988 22 11.9777ZM15.5934 10.9428C16.1767 11.5282 16.1765 12.4734 15.5931 13.0587C14.514 14.1412 12.9604 15.6995 12.7099 15.95C12.3199 16.34 11.6799 16.34 11.2899 15.95C10.8999 15.56 10.8999 14.93 11.2899 14.54C11.8005 14.0294 12.3667 13.5775 12.979 13.1946L13.366 12.9525L13.1589 12.7469C12.4252 12.9155 11.6739 13.0009 10.9195 13.0009L2.9976 13.0009C2.44532 13.0009 1.9976 12.5531 1.9976 12.0009C1.9976 11.4486 2.44532 11.0009 2.9976 11.0009L10.9195 11.0009C11.6739 11.0009 12.4252 11.0862 13.1589 11.2548L13.366 11.0492L12.98 10.8077C12.3671 10.4244 11.801 9.97115 11.2899 9.46001C10.8999 9.07001 10.8999 8.44001 11.2899 8.05001C11.6799 7.66001 12.3199 7.66001 12.7099 8.05001C12.9604 8.30055 14.5142 9.85975 15.5934 10.9428Z"
        fill="currentColor"
      />
    </svg>
  );
});
