import React, { SVGAttributes, forwardRef } from 'react';

export interface MailProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Mail = forwardRef<SVGSVGElement, MailProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M5.20486 5H18.7951C19.9095 5 20.3137 5.11603 20.7211 5.33392C21.1285 5.5518 21.4482 5.87154 21.6661 6.27894C21.884 6.68635 22 7.09046 22 8.20486V15.7951C22 16.9095 21.884 17.3136 21.6661 17.7211C21.4482 18.1285 21.1285 18.4482 20.7211 18.6661C20.3137 18.884 19.9095 19 18.7951 19H5.20486C4.09046 19 3.68635 18.884 3.27894 18.6661C2.87154 18.4482 2.5518 18.1285 2.33392 17.7211C2.11603 17.3136 2 16.9095 2 15.7951V8.20486C2 7.09046 2.11603 6.68635 2.33392 6.27894C2.5518 5.87154 2.87154 5.5518 3.27894 5.33392C3.68635 5.11603 4.09046 5 5.20486 5ZM4 9.5L3.85526 7.76316L3.93942 7.70705L4.99768 8.63046L10.5603 12.549C11.4237 13.1573 12.5763 13.1573 13.4397 12.549L18.9978 8.63366L20.0603 7.70689L20.1447 7.76316L20 9.5V15.7951C20 16.2216 19.981 16.4887 19.951 16.644C19.9393 16.7048 19.9343 16.7183 19.9025 16.7779C19.871 16.8367 19.8367 16.871 19.7779 16.9025C19.7183 16.9343 19.7048 16.9393 19.644 16.951C19.4887 16.981 19.2216 17 18.7951 17H5.20486C4.77844 17 4.51125 16.981 4.35599 16.951C4.29517 16.9393 4.28173 16.9343 4.22214 16.9025C4.16327 16.871 4.12903 16.8367 4.09754 16.7779C4.06567 16.7183 4.06072 16.7048 4.04897 16.644C4.01899 16.4887 4 16.2216 4 15.7951V9.5ZM18.55 6.7L16 7H8L5.45 6.7L5.34713 6.76858C6.07761 7.05861 6.77213 7.43405 7.416 7.88762L11.7121 10.9139C11.8847 11.0356 12.1153 11.0356 12.2879 10.9139L16.5813 7.88952C17.2262 7.43522 17.9219 7.05931 18.6537 6.7691L18.55 6.7Z"
        fill="currentColor"
      />
    </svg>
  );
});
