import React, { SVGAttributes, forwardRef } from 'react';

export interface MailPlusProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const MailPlus = forwardRef<SVGSVGElement, MailPlusProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M3.20486 2H16.7951C17.9095 2 18.3137 2.11603 18.7211 2.33392C19.1285 2.5518 19.4482 2.87154 19.6661 3.27894C19.884 3.68635 20 4.09046 20 5.20486V8.51212C19.3632 8.28703 18.6935 8.13159 18 8.05493V6.5L18.1447 4.76316L18.0603 4.70689L16.9978 5.63365L11.4397 9.54898C10.5763 10.1572 9.42372 10.1572 8.56025 9.54898L2.99768 5.63046L1.93943 4.70705L1.85526 4.76316L2 6.5V12.7951C2 13.2216 2.01899 13.4887 2.04897 13.644C2.06072 13.7048 2.06567 13.7183 2.09754 13.7779C2.12903 13.8367 2.16327 13.871 2.22214 13.9025C2.28173 13.9343 2.29517 13.9393 2.35599 13.951C2.51125 13.981 2.77844 14 3.20486 14H8.51212C8.28703 14.6368 8.13159 15.3065 8.05493 16H3.20486C2.09046 16 1.68635 15.884 1.27894 15.6661C0.871535 15.4482 0.5518 15.1285 0.333916 14.7211C0.116032 14.3136 0 13.9095 0 12.7951V5.20486C0 4.09046 0.116032 3.68635 0.333916 3.27894C0.5518 2.87154 0.871535 2.5518 1.27894 2.33392C1.68635 2.11603 2.09046 2 3.20486 2ZM16.55 3.7L14 4H6L3.45 3.7L3.34714 3.76858C4.07762 4.0586 4.77213 4.43404 5.416 4.88761L9.71205 7.91394C9.88474 8.03559 10.1153 8.03559 10.2879 7.91394L14.5813 4.88951C15.2262 4.43521 15.9219 4.05931 16.6536 3.7691L16.55 3.7ZM17 12C14.2386 12 12 14.2386 12 17C12 19.7614 14.2386 22 17 22C19.7614 22 22 19.7614 22 17C22 14.2386 19.7614 12 17 12ZM10 17C10 13.134 13.134 10 17 10C20.866 10 24 13.134 24 17C24 20.866 20.866 24 17 24C13.134 24 10 20.866 10 17ZM17 13.5C16.4477 13.5 16 13.9477 16 14.5V16H14.5C13.9477 16 13.5 16.4477 13.5 17C13.5 17.5523 13.9477 18 14.5 18H16V19.5C16 20.0523 16.4477 20.5 17 20.5C17.5523 20.5 18 20.0523 18 19.5V18H19.5C20.0523 18 20.5 17.5523 20.5 17C20.5 16.4477 20.0523 16 19.5 16H18V14.5C18 13.9477 17.5523 13.5 17 13.5Z"
        fill="currentColor"
      />
    </svg>
  );
});
