import React, { SVGAttributes, forwardRef } from 'react';

export interface NotificationProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Notification = forwardRef<SVGSVGElement, NotificationProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M2 8.80098C2 7.12082 2 6.28074 2.32698 5.63901C2.6146 5.07452 3.07354 4.61558 3.63803 4.32796C4.27976 4.00098 5.11984 4.00098 6.8 4.00098H17.2C18.8802 4.00098 19.7202 4.00098 20.362 4.32796C20.9265 4.61558 21.3854 5.07452 21.673 5.63901C22 6.28074 22 7.12082 22 8.80098V14.201C22 15.8811 22 16.7212 21.673 17.3629C21.3854 17.9274 20.9265 18.3864 20.362 18.674C19.7202 19.001 18.8802 19.001 17.2 19.001H12L7.49251 22.006C7.00768 22.3292 6.76526 22.4908 6.56424 22.4788C6.38911 22.4683 6.22734 22.3818 6.12149 22.2418C6 22.0812 6 21.7899 6 21.2072V19.001C5.07003 19.001 4.60504 19.001 4.22354 18.8988C3.18827 18.6214 2.37962 17.8127 2.10222 16.7774C2 16.3959 2 15.9309 2 15.001V8.80098ZM4 7.00098C4 6.44869 4.44772 6.00098 5 6.00098H19C19.5523 6.00098 20 6.44869 20 7.00098V16.001C20 16.5533 19.5523 17.001 19 17.001H11.2624L8 19.3021V18.501C8 18.035 8 17.8021 7.92388 17.6183C7.82239 17.3733 7.62771 17.1786 7.38268 17.0771C7.19891 17.001 6.96594 17.001 6.5 17.001H5C4.44772 17.001 4 16.5533 4 16.001V7.00098ZM12 12.501C12.5523 12.501 13 12.0533 13 11.501C13 10.9487 12.5523 10.501 12 10.501C11.4477 10.501 11 10.9487 11 11.501C11 12.0533 11.4477 12.501 12 12.501ZM16.5 11.501C16.5 12.0533 16.0523 12.501 15.5 12.501C14.9477 12.501 14.5 12.0533 14.5 11.501C14.5 10.9487 14.9477 10.501 15.5 10.501C16.0523 10.501 16.5 10.9487 16.5 11.501ZM8.5 12.501C9.05228 12.501 9.5 12.0533 9.5 11.501C9.5 10.9487 9.05228 10.501 8.5 10.501C7.94772 10.501 7.5 10.9487 7.5 11.501C7.5 12.0533 7.94772 12.501 8.5 12.501Z"
        fill="currentColor"
      />
    </svg>
  );
});
