import React, { SVGAttributes, forwardRef } from 'react';

export interface PencilProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Pencil = forwardRef<SVGSVGElement, PencilProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        d="M14.7929 7.36969L6.43207 15.7294C6.25233 15.9091 6.10849 16.1214 6.00826 16.355L4.28017 19.5217L7.64458 17.9911C7.87773 17.8909 8.08968 17.7472 8.26911 17.5677L16.629 9.2063C16.4378 8.87658 16.168 8.53467 15.8156 8.18229C15.4637 7.83036 15.1222 7.5608 14.7929 7.36969ZM16.2387 5.92403C16.5742 6.16086 16.9044 6.4426 17.2298 6.76808C17.5557 7.09392 17.8377 7.42449 18.0747 7.76031L19.5458 6.28888C19.6879 6.1468 19.7311 5.93351 19.6556 5.74735C19.5489 5.48452 19.3579 5.20977 19.0735 4.92535C18.7891 4.64093 18.5143 4.44994 18.2515 4.34329C18.0653 4.26774 17.852 4.31096 17.7099 4.45301L16.2387 5.92403ZM4.17034 15.5663C4.3708 15.0991 4.65847 14.6745 5.01795 14.3151L16.2958 3.0387C17.0062 2.32842 18.0727 2.11233 19.0036 2.49007C19.5295 2.70349 20.0234 3.04688 20.4877 3.51113C20.952 3.9754 21.2954 4.46938 21.5088 4.99531C21.8865 5.92611 21.6704 6.99259 20.9602 7.70296L9.68346 18.9818C9.3246 19.3407 8.9007 19.6281 8.43439 19.8285L4.9916 21.3084C4.10366 21.6901 3.07443 21.2797 2.69275 20.3917C2.50325 19.9509 2.50309 19.4515 2.69233 19.0105L4.17034 15.5663Z"
        fill="currentColor"
      />
    </svg>
  );
});
