import React, { SVGAttributes, forwardRef } from 'react';

export interface PercentProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Percent = forwardRef<SVGSVGElement, PercentProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M7.2522 10.5C5.18113 10.5 3.5022 8.82107 3.5022 6.75C3.5022 4.67893 5.18113 3 7.2522 3C9.32327 3 11.0022 4.67893 11.0022 6.75C11.0022 8.82107 9.32327 10.5 7.2522 10.5ZM5.7093 19.7071C5.31878 20.0976 4.68561 20.0976 4.29509 19.7071C3.90457 19.3166 3.90457 18.6834 4.29509 18.2929L18.2951 4.29289C18.6856 3.90237 19.3188 3.90237 19.7093 4.29289C20.0998 4.68342 20.0998 5.31658 19.7093 5.70711L5.7093 19.7071ZM13.0022 17.25C13.0022 19.3211 14.6811 21 16.7522 21C18.8233 21 20.5022 19.3211 20.5022 17.25C20.5022 15.1789 18.8233 13.5 16.7522 13.5C14.6811 13.5 13.0022 15.1789 13.0022 17.25ZM7.2522 8.5C8.2187 8.5 9.0022 7.7165 9.0022 6.75C9.0022 5.7835 8.2187 5 7.2522 5C6.2857 5 5.5022 5.7835 5.5022 6.75C5.5022 7.7165 6.2857 8.5 7.2522 8.5ZM18.5022 17.25C18.5022 18.2165 17.7187 19 16.7522 19C15.7857 19 15.0022 18.2165 15.0022 17.25C15.0022 16.2835 15.7857 15.5 16.7522 15.5C17.7187 15.5 18.5022 16.2835 18.5022 17.25Z"
        fill="currentColor"
      />
    </svg>
  );
});
