import React, { SVGAttributes, forwardRef } from 'react';

export interface PhoneCheckProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const PhoneCheck = forwardRef<SVGSVGElement, PhoneCheckProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M2 6.8C2 5.11984 2 4.27976 2.32698 3.63803C2.6146 3.07354 3.07354 2.6146 3.63803 2.32698C4.27976 2 5.11984 2 6.8 2H9.2C10.8802 2 11.7202 2 12.362 2.32698C12.9265 2.6146 13.3854 3.07354 13.673 3.63803C14 4.27976 14 5.11984 14 6.8V8.51212C13.2879 8.76379 12.617 9.10253 12 9.51555V5.70526C12 5.14521 12 4.86518 11.891 4.65127C11.7951 4.46311 11.6422 4.31013 11.454 4.21426C11.2401 4.10526 10.9601 4.10526 10.4 4.10526H5.6C5.03995 4.10526 4.75992 4.10526 4.54601 4.21426C4.35785 4.31013 4.20487 4.46311 4.10899 4.65127C4 4.86518 4 5.14521 4 5.70527V18.2947C4 18.8548 4 19.1348 4.10899 19.3487C4.20487 19.5369 4.35785 19.6899 4.54601 19.7857C4.75992 19.8947 5.03995 19.8947 5.6 19.8947H8.47565C8.73067 20.646 9.08221 21.3526 9.51549 21.9999L9.2 22H6.8C5.11984 22 4.27976 22 3.63803 21.673C3.07354 21.3854 2.6146 20.9265 2.32698 20.362C2 19.7202 2 18.8802 2 17.2V6.8ZM6.5 17H8C8 17.6874 8.07706 18.3568 8.22302 19H6.5C5.94772 19 5.5 18.5523 5.5 18C5.5 17.4477 5.94772 17 6.5 17ZM17 12C14.2386 12 12 14.2386 12 17C12 19.7614 14.2386 22 17 22C19.7614 22 22 19.7614 22 17C22 14.2386 19.7614 12 17 12ZM10 17C10 13.134 13.134 10 17 10C20.866 10 24 13.134 24 17C24 20.866 20.866 24 17 24C13.134 24 10 20.866 10 17ZM20.1174 15.1192C19.7268 14.7286 19.0937 14.7286 18.7032 15.1192L16.2706 17.5517L15.5066 16.7877C15.116 16.3972 14.4829 16.3972 14.0923 16.7877C13.7018 17.1783 13.7018 17.8114 14.0923 18.202L15.5657 19.6753C15.9562 20.0658 16.5894 20.0658 16.9799 19.6753C16.9988 19.6563 17.0169 19.6368 17.034 19.6167L20.1174 16.5334C20.5079 16.1428 20.5079 15.5097 20.1174 15.1192Z"
        fill="currentColor"
      />
    </svg>
  );
});
