import React, { SVGAttributes, forwardRef } from 'react';

export interface PhoneCrossProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const PhoneCross = forwardRef<SVGSVGElement, PhoneCrossProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M2 6.8C2 5.11984 2 4.27976 2.32698 3.63803C2.6146 3.07354 3.07354 2.6146 3.63803 2.32698C4.27976 2 5.11984 2 6.8 2H9.2C10.8802 2 11.7202 2 12.362 2.32698C12.9265 2.6146 13.3854 3.07354 13.673 3.63803C14 4.27976 14 5.11984 14 6.8V8.51212C13.2879 8.76379 12.617 9.10253 12 9.51555V5.70526C12 5.14521 12 4.86518 11.891 4.65127C11.7951 4.46311 11.6422 4.31013 11.454 4.21426C11.2401 4.10526 10.9601 4.10526 10.4 4.10526H5.6C5.03995 4.10526 4.75992 4.10526 4.54601 4.21426C4.35785 4.31013 4.20487 4.46311 4.10899 4.65127C4 4.86518 4 5.14521 4 5.70527V18.2947C4 18.8548 4 19.1348 4.10899 19.3487C4.20487 19.5369 4.35785 19.6899 4.54601 19.7857C4.75992 19.8947 5.03995 19.8947 5.6 19.8947H8.47565C8.73067 20.646 9.08221 21.3526 9.51549 21.9999L9.2 22H6.8C5.11984 22 4.27976 22 3.63803 21.673C3.07354 21.3854 2.6146 20.9265 2.32698 20.362C2 19.7202 2 18.8802 2 17.2V6.8ZM6.5 17H8C8 17.6874 8.07706 18.3568 8.22302 19H6.5C5.94772 19 5.5 18.5523 5.5 18C5.5 17.4477 5.94772 17 6.5 17ZM17 12C14.2386 12 12 14.2386 12 17C12 19.7614 14.2386 22 17 22C19.7614 22 22 19.7614 22 17C22 14.2386 19.7614 12 17 12ZM10 17C10 13.134 13.134 10 17 10C20.866 10 24 13.134 24 17C24 20.866 20.866 24 17 24C13.134 24 10 20.866 10 17ZM19.4749 14.5251C19.0844 14.1346 18.4512 14.1346 18.0607 14.5251L17 15.5858L15.9393 14.5251C15.5488 14.1346 14.9157 14.1346 14.5251 14.5251C14.1346 14.9157 14.1346 15.5488 14.5251 15.9393L15.5858 17L14.5251 18.0607C14.1346 18.4512 14.1346 19.0844 14.5251 19.4749C14.9157 19.8654 15.5488 19.8654 15.9393 19.4749L17 18.4142L18.0607 19.4749C18.4512 19.8654 19.0844 19.8654 19.4749 19.4749C19.8654 19.0844 19.8654 18.4512 19.4749 18.0607L18.4142 17L19.4749 15.9393C19.8654 15.5488 19.8654 14.9157 19.4749 14.5251Z"
        fill="currentColor"
      />
    </svg>
  );
});
