import React, { SVGAttributes, forwardRef } from 'react';

export interface PhoneLoginProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const PhoneLogin = forwardRef<SVGSVGElement, PhoneLoginProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M2.32698 3.63803C2 4.27976 2 5.11984 2 6.8V17.2C2 18.8802 2 19.7202 2.32698 20.362C2.6146 20.9265 3.07354 21.3854 3.63803 21.673C4.27976 22 5.11984 22 6.8 22H9.2C9.90008 22 10.4543 22 10.9091 21.9763C11.3693 21.2801 12.2139 20.3243 13.237 20H10.4H9.38702H5.6C5.03995 20 4.75992 20 4.54601 19.891C4.35785 19.7951 4.20487 19.6422 4.10899 19.454C4 19.2401 4 18.9601 4 18.4V5.6C4 5.03995 4 4.75992 4.10899 4.54601C4.20487 4.35785 4.35785 4.20487 4.54601 4.10899C4.75992 4 5.03995 4 5.6 4H10.4C10.9601 4 11.2401 4 11.454 4.10899C11.6422 4.20487 11.7951 4.35785 11.891 4.54601C12 4.75992 12 5.03995 12 5.6V11.2951C12.4068 10.3997 13.1797 9.51066 14 9L14 6.8C14 5.11984 14 4.27976 13.673 3.63803C13.3854 3.07354 12.9265 2.6146 12.362 2.32698C11.7202 2 10.8802 2 9.2 2H6.8C5.11984 2 4.27976 2 3.63803 2.32698C3.07354 2.6146 2.6146 3.07354 2.32698 3.63803ZM5.5 18C5.5 17.4477 5.94772 17 6.5 17H9.5C10.0523 17 10.5 17.4477 10.5 18C10.5 18.5523 10.0523 19 9.5 19H6.5C5.94772 19 5.5 18.5523 5.5 18ZM15.5 14.142C15.5 16.0975 16.6661 17 17.5009 17C18.3347 17 19.5 16.0988 19.5 14.142C19.5 13.2761 19.2558 12.7746 19.006 12.5067C18.7751 12.2591 18.3453 12 17.5009 12C16.6565 12 16.2259 12.2591 15.9945 12.5072C15.7443 12.7753 15.5 13.2767 15.5 14.142ZM13.5 14.142C13.5 16.7564 15.1632 19 17.5009 19C19.8386 19 21.5 16.7564 21.5 14.142C21.5 11.6667 20.083 10 17.5009 10C14.9188 10 13.5 11.6667 13.5 14.142ZM14.2071 23.7071C14.9771 22.9371 16.1985 22.5 17.5 22.5C18.8015 22.5 20.0229 22.9371 20.7929 23.7071C21.1834 24.0976 21.8166 24.0976 22.2071 23.7071C22.5976 23.3166 22.5976 22.6834 22.2071 22.2929C20.9771 21.0629 19.1985 20.5 17.5 20.5C15.8015 20.5 14.0229 21.0629 12.7929 22.2929C12.4024 22.6834 12.4024 23.3166 12.7929 23.7071C13.1834 24.0976 13.8166 24.0976 14.2071 23.7071Z"
        fill="currentColor"
      />
    </svg>
  );
});
