import React, { SVGAttributes, forwardRef } from 'react';

export interface PhoneMailProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const PhoneMail = forwardRef<SVGSVGElement, PhoneMailProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M2 6.8C2 5.11984 2 4.27976 2.32698 3.63803C2.6146 3.07354 3.07354 2.6146 3.63803 2.32698C4.27976 2 5.11984 2 6.8 2H9.2C10.8802 2 11.7202 2 12.362 2.32698C12.9265 2.6146 13.3854 3.07354 13.673 3.63803C14 4.27976 14 5.11984 14 6.8V9H12V5.70526C12 5.14521 12 4.86518 11.891 4.65127C11.7951 4.46311 11.6422 4.31013 11.454 4.21426C11.2401 4.10526 10.9601 4.10526 10.4 4.10526H5.6C5.03995 4.10526 4.75992 4.10526 4.54601 4.21426C4.35785 4.31013 4.20487 4.46311 4.10899 4.65127C4 4.86518 4 5.14521 4 5.70527V18.2947C4 18.8548 4 19.1348 4.10899 19.3487C4.20487 19.5369 4.35785 19.6899 4.54601 19.7857C4.75992 19.8947 5.03995 19.8947 5.6 19.8947H6V21.9983C4.83507 21.9902 4.16873 21.9434 3.63803 21.673C3.07354 21.3854 2.6146 20.9265 2.32698 20.362C2 19.7202 2 18.8802 2 17.2V6.8ZM11 11H14H20C21.6569 11 23 12.3431 23 14V19C23 20.6569 21.6569 22 20 22H11C9.34315 22 8 20.6569 8 19V14C8 12.3431 9.34315 11 11 11ZM14 14.7917L14 13H11C10.7405 13 10.504 13.0989 10.3263 13.261L14 14.7917ZM13.9999 16.9583L13.9999 17.4691L14 17.2V16.9583L14.7308 17.2628C15.2231 17.468 15.7769 17.468 16.2692 17.2628L21 15.2917V19C21 19.5523 20.5523 20 20 20H11C10.4477 20 10 19.5523 10 19V15.2917L13.9999 16.9583ZM20.6737 13.261L15.5 15.4167L14 14.7917V13H20C20.2595 13 20.496 13.0989 20.6737 13.261Z"
        fill="currentColor"
      />
    </svg>
  );
});
