import React, { SVGAttributes, forwardRef } from 'react';

export interface PhoneNotificationProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const PhoneNotification = forwardRef<SVGSVGElement, PhoneNotificationProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M2 6.8C2 5.11984 2 4.27976 2.32698 3.63803C2.6146 3.07354 3.07354 2.6146 3.63803 2.32698C4.27976 2 5.11984 2 6.8 2H9.2C10.8802 2 11.7202 2 12.362 2.32698C12.9265 2.6146 13.3854 3.07354 13.673 3.63803C14 4.27976 14 5.11984 14 6.8V10H12V5.70526C12 5.14521 12 4.86518 11.891 4.65127C11.7951 4.46311 11.6422 4.31013 11.454 4.21426C11.2401 4.10526 10.9601 4.10526 10.4 4.10526H5.6C5.03995 4.10526 4.75992 4.10526 4.54601 4.21426C4.35785 4.31013 4.20487 4.46311 4.10899 4.65127C4 4.86518 4 5.14521 4 5.70527V18.2947C4 18.8548 4 19.1348 4.10899 19.3487C4.20487 19.5369 4.35785 19.6899 4.54601 19.7857C4.75992 19.8947 5.03995 19.8947 5.6 19.8947H9V22H6.8C5.11984 22 4.27976 22 3.63803 21.673C3.07354 21.3854 2.6146 20.9265 2.32698 20.362C2 19.7202 2 18.8802 2 17.2V6.8ZM6.5 17H9V19H6.5C5.94772 19 5.5 18.5523 5.5 18C5.5 17.4477 5.94772 17 6.5 17ZM11 14C11 12.8954 11.8954 12 13 12H22C23.1046 12 24 12.8954 24 14V19C24 20.1046 23.1046 21 22 21H18L14.8 23.4C14.4704 23.6472 14 23.412 14 23V21H13C11.8954 21 11 20.1046 11 19V14ZM13 14H22V19H17.6L15.5 20.5V19.5C15.5 19.2239 15.2761 19 15 19H14H13V14Z"
        fill="currentColor"
      />
    </svg>
  );
});
