import React, { SVGAttributes, forwardRef } from 'react';

export interface PhoneRefreshProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const PhoneRefresh = forwardRef<SVGSVGElement, PhoneRefreshProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M2.32698 3.63803C2 4.27976 2 5.11984 2 6.8V17.2C2 18.8802 2 19.7202 2.32698 20.362C2.6146 20.9265 3.07354 21.3854 3.63803 21.673C4.27976 22 5.11984 22 6.8 22H8.71429L8.11278 19.8947H5.6C5.03995 19.8947 4.75992 19.8947 4.54601 19.7857C4.35785 19.6899 4.20487 19.5369 4.10899 19.3487C4 19.1348 4 18.8548 4 18.2947V5.70527C4 5.14521 4 4.86518 4.10899 4.65127C4.20487 4.46311 4.35785 4.31013 4.54601 4.21426C4.75992 4.10526 5.03995 4.10526 5.6 4.10526H10.4C10.9601 4.10526 11.2401 4.10526 11.454 4.21426C11.6422 4.31013 11.7951 4.46311 11.891 4.65127C12 4.86518 12 5.14521 12 5.70526V9.51555C12.617 9.10253 13.2879 8.76379 14 8.51212V6.8C14 5.11984 14 4.27976 13.673 3.63803C13.3854 3.07354 12.9265 2.6146 12.362 2.32698C11.7202 2 10.8802 2 9.2 2H6.8C5.11984 2 4.27976 2 3.63803 2.32698C3.07354 2.6146 2.6146 3.07354 2.32698 3.63803ZM6.5 17H8V19H6.5C5.94772 19 5.5 18.5523 5.5 18C5.5 17.4477 5.94772 17 6.5 17ZM23.6709 15.0128C23.8328 15.4985 23.4713 16 22.9594 16H19.4014C18.8024 16 18.4451 15.3324 18.7773 14.834L19.4444 13.8334C18.768 13.3103 17.9209 13 17 13C15.3613 13 13.9506 13.9856 13.3324 15.4004C13.1113 15.9065 12.5218 16.1375 12.0157 15.9164C11.5096 15.6952 11.2786 15.1057 11.4997 14.5996C12.4246 12.4826 14.5381 11 17 11C18.3305 11 19.5608 11.4339 20.5556 12.1666L21.1494 11.2759C21.4956 10.7566 22.2876 10.8627 22.4849 11.4548L23.6709 15.0128ZM22.5003 19.4004C22.7214 18.8943 22.4904 18.3048 21.9843 18.0836C21.4782 17.8625 20.8887 18.0935 20.6676 18.5996C20.0494 20.0144 18.6387 21 17 21C16.079 21 15.232 20.6897 14.5556 20.1666L15.2226 19.166C15.5549 18.6676 15.1976 18 14.5986 18H11.0406C10.5287 18 10.1672 18.5015 10.3291 18.9872L11.5151 22.5452C11.7124 23.1373 12.5044 23.2434 12.8506 22.7241L13.4444 21.8334C14.4392 22.5661 15.6696 23 17 23C19.4619 23 21.5754 21.5174 22.5003 19.4004Z"
        fill="currentColor"
      />
    </svg>
  );
});
