import React, { SVGAttributes, forwardRef } from 'react';

export interface PhoneShieldProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const PhoneShield = forwardRef<SVGSVGElement, PhoneShieldProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M2 6.8C2 5.11984 2 4.27976 2.32698 3.63803C2.6146 3.07354 3.07354 2.6146 3.63803 2.32698C4.27976 2 5.11984 2 6.8 2H9.2C10.8802 2 11.7202 2 12.362 2.32698C12.9265 2.6146 13.3854 3.07354 13.673 3.63803C14 4.27976 14 5.11984 14 6.8V10.9375L12 11.5625V5.70526C12 5.14521 12 4.86518 11.891 4.65127C11.7951 4.46311 11.6422 4.31013 11.454 4.21426C11.2401 4.10526 10.9601 4.10526 10.4 4.10526H5.6C5.03995 4.10526 4.75992 4.10526 4.54601 4.21426C4.35785 4.31013 4.20487 4.46311 4.10899 4.65127C4 4.86518 4 5.14521 4 5.70527V18.2947C4 18.8548 4 19.1348 4.10899 19.3487C4.20487 19.5369 4.35785 19.6899 4.54601 19.7857C4.75992 19.8947 5.03995 19.8947 5.6 19.8947H9.91324C10.1864 20.6342 10.5355 21.3431 10.9805 21.9724C10.5126 22 9.93716 22 9.2 22H6.8C5.11984 22 4.27976 22 3.63803 21.673C3.07354 21.3854 2.6146 20.9265 2.32698 20.362C2 19.7202 2 18.8802 2 17.2V6.8ZM6.5 17H9.19373C9.2922 17.6505 9.4296 18.326 9.6197 18.9929C9.58045 18.9976 9.54051 19 9.5 19H6.5C5.94772 19 5.5 18.5523 5.5 18C5.5 17.4477 5.94772 17 6.5 17ZM17 14.1082L13.0203 15.4348C13.0635 16.5788 13.1982 17.7634 13.6151 18.8405C14.1122 20.1247 15.0241 21.2978 17.001 21.9232C18.9957 21.2969 19.8985 20.1475 20.3876 18.8981C20.8086 17.8226 20.9405 16.6267 20.9816 15.4354L17 14.1082ZM11 14C11 17 11 22.5 17 24.0001C23 22.5 23 17.1722 23 14L17 12L11 14Z"
        fill="currentColor"
      />
    </svg>
  );
});
