import React, { SVGAttributes, forwardRef } from 'react';

export interface PhoneTrashProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const PhoneTrash = forwardRef<SVGSVGElement, PhoneTrashProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M1.32698 1.63803C1 2.27976 1 3.11984 1 4.8V15.2C1 16.8802 1 17.7202 1.32698 18.362C1.6146 18.9265 2.07354 19.3854 2.63803 19.673C3.27976 20 4.11984 20 5.8 20H8.2C9.15657 20 9.84084 20 10.3712 19.9397L10.241 17.8567C10.0497 17.8947 9.79423 17.8947 9.4 17.8947H4.6C4.03995 17.8947 3.75992 17.8947 3.54601 17.7857C3.35785 17.6899 3.20487 17.5369 3.10899 17.3487C3 17.1348 3 16.8548 3 16.2947V3.70527C3 3.14521 3 2.86518 3.10899 2.65127C3.20487 2.46311 3.35785 2.31013 3.54601 2.21426C3.75992 2.10526 4.03995 2.10526 4.6 2.10526H9.4C9.96005 2.10526 10.2401 2.10526 10.454 2.21426C10.6422 2.31013 10.7951 2.46311 10.891 2.65127C11 2.86518 11 3.14521 11 3.70526V9H13V4.8C13 3.11984 13 2.27976 12.673 1.63803C12.3854 1.07354 11.9265 0.614601 11.362 0.32698C10.7202 0 9.88016 0 8.2 0H5.8C4.11984 0 3.27976 0 2.63803 0.32698C2.07354 0.614601 1.6146 1.07354 1.32698 1.63803ZM4.5 16C4.5 15.4477 4.94772 15 5.5 15H8.5C9.05229 15 9.5 15.4477 9.5 16C9.5 16.5523 9.05229 17 8.5 17H5.5C4.94772 17 4.5 16.5523 4.5 16ZM11 13C11 12.4477 11.4477 12 12 12H14V11C14 10.4477 14.4477 10 15 10H18C18.5523 10 19 10.4477 19 11V12H21C21.5523 12 22 12.4477 22 13C22 13.5523 21.5523 14 21 14H20.9395L20.4981 21.0624C20.4651 21.5894 20.0281 22 19.5 22H13.5C12.9719 22 12.5349 21.5894 12.5019 21.0624L12.0605 14H12C11.4477 14 11 13.5523 11 13ZM14.4395 20H18.5605L18.9355 14H14.0645L14.4395 20Z"
        fill="currentColor"
      />
    </svg>
  );
});
