import React, { SVGAttributes, forwardRef } from 'react';

export interface PlusProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Plus = forwardRef<SVGSVGElement, PlusProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M9.17841 0.0863183C8.63206 0.00557234 8.1237 0.383019 8.04295 0.929369C7.9622 1.47572 8.33965 1.98408 8.886 2.06483C11.7793 2.49243 14 4.98777 14 8C14 8.17519 13.9925 8.34863 13.9778 8.52001C14.6212 8.29069 15.2983 8.13252 15.9998 8.05496L16 8C16 3.98162 13.0383 0.656773 9.17841 0.0863183ZM9.27936 12.3722C9.83262 11.4512 10.546 10.6373 11.3811 9.9691C11.0141 9.55858 10.3839 9.52188 9.97176 9.88769C9.59072 10.2259 8.88925 10.5116 8.00768 10.5116C7.1261 10.5116 6.42463 10.2259 6.04359 9.88769C5.63053 9.52108 4.99849 9.55874 4.63188 9.9718C4.26527 10.3849 4.30293 11.0169 4.71598 11.3835C5.53356 12.1091 6.74017 12.5116 8.00768 12.5116C8.4432 12.5116 8.87153 12.4641 9.27936 12.3722ZM8.05495 15.9998C8.13251 15.2983 8.29069 14.6212 8.52001 13.9778C8.34863 13.9925 8.17519 14 8 14C4.68629 14 2 11.3137 2 8C2 5.60802 3.39967 3.54097 5.42909 2.57689C5.92795 2.33991 6.14024 1.7434 5.90326 1.24454C5.66628 0.745683 5.06976 0.53339 4.57091 0.770371C1.87043 2.05323 0 4.80719 0 8C0 12.4183 3.58172 16 8 16L8.05495 15.9998ZM17 12C14.2386 12 12 14.2386 12 17C12 19.7614 14.2386 22 17 22C19.7614 22 22 19.7614 22 17C22 14.2386 19.7614 12 17 12ZM10 17C10 13.134 13.134 10 17 10C20.866 10 24 13.134 24 17C24 20.866 20.866 24 17 24C13.134 24 10 20.866 10 17ZM17 13.5C16.4477 13.5 16 13.9477 16 14.5V16H14.5C13.9477 16 13.5 16.4477 13.5 17C13.5 17.5523 13.9477 18 14.5 18H16V19.5C16 20.0523 16.4477 20.5 17 20.5C17.5523 20.5 18 20.0523 18 19.5V18H19.5C20.0523 18 20.5 17.5523 20.5 17C20.5 16.4477 20.0523 16 19.5 16H18V14.5C18 13.9477 17.5523 13.5 17 13.5Z"
        fill="currentColor"
      />
    </svg>
  );
});
