import React, { SVGAttributes, forwardRef } from 'react';

export interface ProfileProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Profile = forwardRef<SVGSVGElement, ProfileProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M12 14.35C8.75003 14.35 7.00003 11.1754 7.00003 7.625C7.00003 4.15 9.00003 2 12 2C15 2 17 4.15 17 7.625C17 11.1754 15.25 14.35 12 14.35ZM12 12.35C13.7395 12.35 15 10.5013 15 7.625C15 5.24619 13.8781 4 12 4C10.122 4 9.00003 5.24619 9.00003 7.625C9.00003 10.5013 10.2606 12.35 12 12.35ZM4.94014 21.9982C5.49143 22.0313 5.96516 21.6112 5.99824 21.0599C6.11356 19.1378 8.04132 18 12.0038 18C15.9644 18 17.8868 19.1363 18.0035 21.0606C18.037 21.6118 18.511 22.0316 19.0623 21.9982C19.6135 21.9647 20.0333 21.4907 19.9999 20.9394C19.8047 17.7224 16.8907 16 12.0038 16C7.11485 16 4.19482 17.7235 4.00183 20.9401C3.96875 21.4914 4.38885 21.9651 4.94014 21.9982Z"
        fill="currentColor"
      />
    </svg>
  );
});
