import React, { SVGAttributes, forwardRef } from 'react';

export interface ProfileCircleProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const ProfileCircle = forwardRef<SVGSVGElement, ProfileCircleProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M17.903 17.3996C19.2054 15.9766 20 14.0811 20 12C20 7.58172 16.4183 4 12 4C7.58172 4 4 7.58172 4 12C4 14.0811 4.79467 15.9767 6.09712 17.3997C7.59315 15.6892 9.83127 14.875 12.0001 14.875C14.1688 14.875 16.4069 15.6892 17.903 17.3996ZM16.3792 18.6961C15.326 17.5089 13.6973 16.875 12.0001 16.875C10.3029 16.875 8.67409 17.5089 7.62091 18.6961C8.879 19.5206 10.3835 20 12 20C13.6165 20 15.1211 19.5205 16.3792 18.6961ZM12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22ZM10.9233 11.5555C11.3031 12.0623 11.696 12.2222 12.0007 12.2222C12.3052 12.2222 12.6977 12.0625 13.0771 11.5559C13.4595 11.0452 13.7222 10.2986 13.7222 9.5C13.7222 8.48161 13.0179 7.77778 12.0007 7.77778C10.9825 7.77778 10.2778 8.48254 10.2778 9.5C10.2778 10.2982 10.5406 11.0447 10.9233 11.5555ZM12.0007 14C10.0014 14 8.5 11.8239 8.5 9.5C8.5 7.5 10.0014 6 12.0007 6C14 6 15.5 7.5 15.5 9.5C15.5 11.8239 14 14 12.0007 14Z"
        fill="#262633"
      />
    </svg>
  );
});
