import React, { SVGAttributes, forwardRef } from 'react';

import { useUniqId } from '@use-platform/react';

export interface ProgressSmileProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
}

export const ProgressSmile = forwardRef<SVGSVGElement, ProgressSmileProps>((props, ref) => {
  const { className, ...otherProps } = props;
  const id = useUniqId();

  return (
    <svg
      width="32"
      height="32"
      viewBox="0 0 32 32"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M28.789 13.6609L30.789 13.3009C30.1574 9.84917 28.3358 6.72817 25.6408 4.48083C22.9459 2.2335 19.5481 1.00215 16.039 1.00098V3.00098C19.0745 3.00977 22.0113 4.08044 24.3401 6.02747C26.6688 7.97449 28.2427 10.675 28.789 13.6609ZM28.9992 16.001C28.9973 18.4547 28.3011 20.8577 26.9909 22.9324C25.6807 25.007 23.8101 26.6686 21.5954 27.7249C19.3806 28.7811 16.9121 29.189 14.4753 28.9014C12.0385 28.6138 9.73284 27.6425 7.82488 26.0996C5.91691 24.5567 4.48445 22.5053 3.69328 20.1826C2.90212 17.8599 2.78449 15.3609 3.35393 12.9741C3.92337 10.5874 5.15673 8.41049 6.9113 6.69519C8.66587 4.97989 10.87 3.79617 13.269 3.28088L12.849 1.28088C10.0807 1.8755 7.53722 3.24155 5.51262 5.22107C3.48802 7.20058 2.06493 9.71275 1.40813 12.467C0.751328 15.2213 0.887511 18.1053 1.80095 20.7854C2.71439 23.4655 4.36786 25.8324 6.56999 27.6123C8.77213 29.3922 11.4332 30.5124 14.2453 30.8435C17.0574 31.1746 19.9056 30.7031 22.4609 29.4833C25.0162 28.2635 27.1741 26.3453 28.685 23.9506C30.1959 21.5559 30.9983 18.7824 30.9992 15.9509L28.9992 16.001ZM8.23911 14.8009C7.96151 12.9326 8.22527 11.0239 8.99912 9.3009L10.849 10.121C10.2179 11.5101 10.0061 13.0531 10.2391 14.5609L8.23911 14.8009ZM21.9093 9.3009C21.1354 11.0239 20.8717 12.9326 21.1493 14.8009L23.1493 14.5609C22.9209 13.0531 23.1328 11.5114 23.7594 10.121L21.9093 9.3009ZM15.8489 22.0095C13.8287 22.0095 11.8722 21.3024 10.3188 20.0109L11.5989 18.4709C12.7903 19.4686 14.2948 20.0153 15.8489 20.0153C17.4029 20.0153 18.9074 19.4686 20.0989 18.4709L21.3789 20.0109C19.8255 21.3024 17.869 22.0095 15.8489 22.0095Z"
        fill="#272733"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M28.789 13.6609L30.789 13.3009C30.1574 9.84917 28.3358 6.72817 25.6408 4.48083C22.9459 2.2335 19.5481 1.00215 16.039 1.00098V3.00098C19.0745 3.00977 22.0113 4.08044 24.3401 6.02747C26.6688 7.97449 28.2427 10.675 28.789 13.6609ZM28.9992 16.001C28.9973 18.4547 28.3011 20.8577 26.9909 22.9324C25.6807 25.007 23.8101 26.6686 21.5954 27.7249C19.3806 28.7811 16.9121 29.189 14.4753 28.9014C12.0385 28.6138 9.73284 27.6425 7.82488 26.0996C5.91691 24.5567 4.48445 22.5053 3.69328 20.1826C2.90212 17.8599 2.78449 15.3609 3.35393 12.9741C3.92337 10.5874 5.15673 8.41049 6.9113 6.69519C8.66587 4.97989 10.87 3.79617 13.269 3.28088L12.849 1.28088C10.0807 1.8755 7.53722 3.24155 5.51262 5.22107C3.48802 7.20058 2.06493 9.71275 1.40813 12.467C0.751328 15.2213 0.887511 18.1053 1.80095 20.7854C2.71439 23.4655 4.36786 25.8324 6.56999 27.6123C8.77213 29.3922 11.4332 30.5124 14.2453 30.8435C17.0574 31.1746 19.9056 30.7031 22.4609 29.4833C25.0162 28.2635 27.1741 26.3453 28.685 23.9506C30.1959 21.5559 30.9983 18.7824 30.9992 15.9509L28.9992 16.001ZM8.23911 14.8009C7.96151 12.9326 8.22527 11.0239 8.99912 9.3009L10.849 10.121C10.2179 11.5101 10.0061 13.0531 10.2391 14.5609L8.23911 14.8009ZM21.9093 9.3009C21.1354 11.0239 20.8717 12.9326 21.1493 14.8009L23.1493 14.5609C22.9209 13.0531 23.1328 11.5114 23.7594 10.121L21.9093 9.3009ZM15.8489 22.0095C13.8287 22.0095 11.8722 21.3024 10.3188 20.0109L11.5989 18.4709C12.7903 19.4686 14.2948 20.0153 15.8489 20.0153C17.4029 20.0153 18.9074 19.4686 20.0989 18.4709L21.3789 20.0109C19.8255 21.3024 17.869 22.0095 15.8489 22.0095Z"
        fill={`url(#${id}paint0_linear_1973_23585)`}
      />
      <defs>
        <linearGradient
          id={`${id}paint0_linear_1973_23585`}
          x1="15.9991"
          y1="1.00098"
          x2="15.9991"
          y2="30.9464"
          gradientUnits="userSpaceOnUse"
        >
          <stop offset="0.346995" stopColor="#58C800" />
          <stop offset="1" stopColor="#00B649" />
        </linearGradient>
      </defs>
    </svg>
  );
});
