import React, { SVGAttributes, forwardRef } from 'react';

export interface QuestionAnswerPlusProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const QuestionAnswerPlus = forwardRef<SVGSVGElement, QuestionAnswerPlusProps>(
  (props, ref) => {
    const { className, size = 24, ...otherProps } = props;

    return (
      <svg
        width={size}
        height={size}
        viewBox="0 0 24 24"
        fill="none"
        {...otherProps}
        focusable="false"
        aria-hidden="true"
        className={'SvgIcon' + (className ? ' ' + className : '')}
        ref={ref}
      >
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M9.00906 0.263548C8.38465 -0.0878491 7.61535 -0.0878493 6.99094 0.263548L1.00906 3.62997C0.38465 3.98137 0 4.63078 0 5.33357V12.0664C0 12.7692 0.38465 13.4186 1.00906 13.77L6.99094 17.1365C7.30575 17.3136 7.6574 17.4015 8.00873 17.4C8.00293 17.2674 8 17.134 8 17C8 16.4356 8.05196 15.8833 8.15134 15.3477L8 15.4329L2.01811 12.0664V5.33357L8 1.96715L13.9819 5.33357V8.51854C14.6241 8.28999 15.3 8.13231 16 8.05493V5.33357C16 4.63078 15.6154 3.98137 14.9909 3.62997L9.00906 0.263548ZM5 7.27814C5 5.62214 6.368 4.61414 8.096 4.61414C9.8 4.61414 11.072 5.62214 11.072 7.11014V7.15814C11.072 8.57414 10.16 9.15014 9.308 9.52214L9.092 9.61814C8.804 9.75014 8.708 9.90614 8.708 10.2541C8.708 10.4264 8.56831 10.5661 8.396 10.5661H7.556C7.31741 10.5661 7.124 10.3727 7.124 10.1341C7.124 9.31814 7.412 8.80214 8.168 8.46614L8.384 8.37014C9.104 8.04614 9.488 7.78214 9.488 7.18214C9.488 6.53414 8.936 6.10214 8.096 6.10214C7.232 6.10214 6.584 6.53414 6.584 7.35014C6.584 7.50919 6.45506 7.63814 6.296 7.63814H5.36C5.16118 7.63814 5 7.47696 5 7.27814ZM6.776 12.2101C6.776 11.5381 7.268 11.0701 7.916 11.0701C8.564 11.0701 9.056 11.5381 9.056 12.2101C9.056 12.8821 8.564 13.3501 7.916 13.3501C7.268 13.3501 6.776 12.8821 6.776 12.2101ZM17 12C14.2386 12 12 14.2386 12 17C12 19.7614 14.2386 22 17 22C19.7614 22 22 19.7614 22 17C22 14.2386 19.7614 12 17 12ZM10 17C10 13.134 13.134 10 17 10C20.866 10 24 13.134 24 17C24 20.866 20.866 24 17 24C13.134 24 10 20.866 10 17ZM17 13.5C16.4477 13.5 16 13.9477 16 14.5V16H14.5C13.9477 16 13.5 16.4477 13.5 17C13.5 17.5523 13.9477 18 14.5 18H16V19.5C16 20.0523 16.4477 20.5 17 20.5C17.5523 20.5 18 20.0523 18 19.5V18H19.5C20.0523 18 20.5 17.5523 20.5 17C20.5 16.4477 20.0523 16 19.5 16H18V14.5C18 13.9477 17.5523 13.5 17 13.5Z"
          fill="currentColor"
        />
      </svg>
    );
  },
);
