import React, { SVGAttributes, forwardRef } from 'react';

export interface RefreshProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Refresh = forwardRef<SVGSVGElement, RefreshProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M9.17841 0.0863183C8.63206 0.00557234 8.1237 0.383019 8.04295 0.929369C7.9622 1.47572 8.33965 1.98408 8.886 2.06483C11.7793 2.49243 14 4.98777 14 8C14 8.17519 13.9925 8.34863 13.9778 8.52001C14.6212 8.29069 15.2983 8.13252 15.9998 8.05496L16 8C16 3.98162 13.0383 0.656773 9.17841 0.0863183ZM9.27936 12.3722C9.83262 11.4512 10.546 10.6373 11.3811 9.9691C11.0141 9.55858 10.3839 9.52188 9.97176 9.88769C9.59072 10.2259 8.88925 10.5116 8.00768 10.5116C7.1261 10.5116 6.42463 10.2259 6.04359 9.88769C5.63053 9.52108 4.99849 9.55874 4.63188 9.9718C4.26527 10.3849 4.30293 11.0169 4.71598 11.3835C5.53356 12.1091 6.74017 12.5116 8.00768 12.5116C8.4432 12.5116 8.87153 12.4641 9.27936 12.3722ZM8.05495 15.9998C8.13251 15.2983 8.29069 14.6212 8.52001 13.9778C8.34863 13.9925 8.17519 14 8 14C4.68629 14 2 11.3137 2 8C2 5.60802 3.39967 3.54097 5.42909 2.57689C5.92795 2.33991 6.14024 1.7434 5.90326 1.24454C5.66628 0.745683 5.06976 0.53339 4.57091 0.770371C1.87043 2.05323 0 4.80719 0 8C0 12.4183 3.58172 16 8 16L8.05495 15.9998ZM23.6709 15.0128C23.8328 15.4985 23.4713 16 22.9594 16H19.4014C18.8024 16 18.4451 15.3324 18.7773 14.834L19.4444 13.8334C18.768 13.3103 17.9209 13 17 13C15.3613 13 13.9506 13.9856 13.3324 15.4004C13.1113 15.9065 12.5218 16.1375 12.0157 15.9164C11.5096 15.6952 11.2786 15.1057 11.4997 14.5996C12.4246 12.4826 14.5381 11 17 11C18.3305 11 19.5608 11.4339 20.5556 12.1666L21.1494 11.2759C21.4956 10.7566 22.2876 10.8627 22.4849 11.4548L23.6709 15.0128ZM22.5003 19.4004C22.7214 18.8943 22.4904 18.3048 21.9843 18.0836C21.4782 17.8625 20.8887 18.0935 20.6676 18.5996C20.0494 20.0144 18.6387 21 17 21C16.079 21 15.232 20.6897 14.5556 20.1666L15.2226 19.166C15.5549 18.6676 15.1976 18 14.5986 18H11.0406C10.5287 18 10.1672 18.5015 10.3291 18.9872L11.5151 22.5452C11.7124 23.1373 12.5044 23.2434 12.8506 22.7241L13.4444 21.8334C14.4392 22.5661 15.6696 23 17 23C19.4619 23 21.5754 21.5174 22.5003 19.4004Z"
        fill="currentColor"
      />
    </svg>
  );
});
