import React, { SVGAttributes, forwardRef } from 'react';

export interface SearchProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
}

export const Search = forwardRef<SVGSVGElement, SearchProps>((props, ref) => {
  const { className, ...otherProps } = props;

  return (
    <svg
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M9.5 16.999C11.2105 16.999 12.7873 16.4264 14.0491 15.4624L18.7929 20.2061C19.1834 20.5967 19.8166 20.5967 20.2071 20.2061C20.5976 19.8156 20.5976 19.1824 20.2071 18.7919L15.4633 14.0481C16.4274 12.7863 17 11.2096 17 9.49902C17 5.35689 13.6421 1.99902 9.5 1.99902C5.35786 1.99902 2 5.35689 2 9.49902C2 13.6412 5.35786 16.999 9.5 16.999ZM15 9.49902C15 12.5366 12.5376 14.999 9.5 14.999C6.46243 14.999 4 12.5366 4 9.49902C4 6.46146 6.46243 3.99902 9.5 3.99902C12.5376 3.99902 15 6.46146 15 9.49902Z"
        fill="#262633"
      />
    </svg>
  );
});
