import React, { SVGAttributes, forwardRef } from 'react';

export interface SettingsOutlineProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const SettingsOutline = forwardRef<SVGSVGElement, SettingsOutlineProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M20.7878 5.276L22.2148 7.759V7.76C22.3835 8.05473 22.4395 8.40068 22.3724 8.73357C22.3052 9.06646 22.1195 9.36368 21.8498 9.57L19.9918 10.982L19.9938 13.02L21.8478 14.43C22.1186 14.6365 22.3049 14.9344 22.3721 15.2682C22.4392 15.602 22.3826 15.9489 22.2128 16.244L20.7878 18.723C20.6174 19.0184 20.3452 19.2415 20.0222 19.3506C19.6992 19.4598 19.3474 19.4475 19.0328 19.316L16.8408 18.396L15.1208 19.378L14.8168 21.776C14.7733 22.114 14.6083 22.4247 14.3525 22.65C14.0967 22.8752 13.7676 22.9996 13.4268 23H10.5738C10.233 22.9994 9.90412 22.8749 9.64837 22.6497C9.39262 22.4245 9.2275 22.114 9.18382 21.776L8.87582 19.355L7.18582 18.385L4.96582 19.315C4.65155 19.4472 4.29982 19.4599 3.97679 19.3509C3.65376 19.2419 3.38171 19.0186 3.21182 18.723L1.78482 16.241C1.61613 15.9463 1.56015 15.6003 1.62728 15.2674C1.69441 14.9345 1.88008 14.6373 2.14982 14.431L4.00882 13.018L4.00582 10.98L2.15082 9.57C1.88042 9.36324 1.6944 9.06524 1.62744 8.7315C1.56047 8.39777 1.61711 8.05107 1.78682 7.756L3.21282 5.277C3.38292 4.98109 3.65526 4.75752 3.97864 4.64831C4.30201 4.53911 4.65414 4.5518 4.96882 4.684L7.15982 5.604L8.87982 4.622L9.18282 2.224C9.2263 1.88595 9.39135 1.57529 9.64715 1.35005C9.90294 1.1248 10.232 1.00037 10.5728 1H13.4258C13.7665 1.00034 14.0954 1.12463 14.3512 1.34967C14.607 1.57472 14.7721 1.88513 14.8158 2.223L15.1228 4.645L16.8128 5.615L19.0328 4.685C19.3471 4.55269 19.6989 4.53973 20.0221 4.64856C20.3453 4.7574 20.6176 4.98052 20.7878 5.276ZM17.9958 14.015L17.9888 9.992L20.2178 8.298L19.3178 6.733L16.6768 7.842L13.2648 5.886L12.8978 3H11.1018L10.7378 5.864L7.29382 7.83L4.68182 6.733L3.78182 8.298L6.00382 9.988L6.01082 14.008L3.78182 15.702L4.68182 17.267L7.32282 16.158L10.7348 18.114L11.1018 21H12.8978L13.2618 18.136L16.7048 16.17L19.3178 17.267L20.2178 15.702L17.9958 14.015ZM9.17133 9.17157C9.92147 8.42143 10.9389 8 11.9998 8C13.0606 8 14.078 8.42143 14.8282 9.17157C15.5783 9.92172 15.9998 10.9391 15.9998 12C15.9998 13.0609 15.5783 14.0783 14.8282 14.8284C14.078 15.5786 13.0606 16 11.9998 16C10.9389 16 9.92147 15.5786 9.17133 14.8284C8.42118 14.0783 7.99976 13.0609 7.99976 12C7.99976 10.9391 8.42118 9.92172 9.17133 9.17157ZM10.5855 13.4142C10.9606 13.7893 11.4693 14 11.9998 14C12.5302 14 13.0389 13.7893 13.414 13.4142C13.789 13.0391 13.9998 12.5304 13.9998 12C13.9998 11.4696 13.789 10.9609 13.414 10.5858C13.0389 10.2107 12.5302 10 11.9998 10C11.4693 10 10.9606 10.2107 10.5855 10.5858C10.2105 10.9609 9.99976 11.4696 9.99976 12C9.99976 12.5304 10.2105 13.0391 10.5855 13.4142Z"
        fill="currentColor"
      />
    </svg>
  );
});
