import React, { SVGAttributes, forwardRef } from 'react';

export interface ShareProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Share = forwardRef<SVGSVGElement, ShareProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M11.0399 3.23821C11.0399 2.61381 11.7296 2.26282 12.2024 2.64657L22.7555 11.2111C23.2488 11.6114 23.2488 12.3884 22.7555 12.7887L12.2024 21.3532C11.7296 21.737 11.0399 21.386 11.0399 20.7616V16.5666C6.835 17.5339 4.21042 19.4815 1.56947 21.7773C1.21999 22.0811 0.693947 21.7603 0.784788 21.2957C1.37245 18.2901 2.08602 15.3331 3.91365 12.8189C5.4649 10.6849 7.72999 8.89789 11.0399 7.82701V3.23821ZM12.9599 5.79667V9.46936C8.51296 10.7153 5.4753 12.8549 3.994 17.4654C6.62663 15.6263 9.59269 14.5287 12.9599 14.0376V18.2031L20.6035 11.9999L12.9599 5.79667Z"
        fill="currentColor"
      />
    </svg>
  );
});
