import React, { SVGAttributes, forwardRef } from 'react';

export interface ShareArrowOutlineProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const ShareArrowOutline = forwardRef<SVGSVGElement, ShareArrowOutlineProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 25 25"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M11.5399 3.24065C11.5399 2.61625 12.2296 2.26526 12.7024 2.64901L23.2555 11.2135C23.7488 11.6139 23.7488 12.3908 23.2555 12.7912L12.7024 21.3557C12.2296 21.7394 11.5399 21.3884 11.5399 20.764V16.5691C7.335 17.5363 4.71042 19.4839 2.06947 21.7797C1.71999 22.0835 1.19395 21.7627 1.28479 21.2981C1.87245 18.2925 2.58602 15.3355 4.41365 12.8214C5.9649 10.6874 8.22999 8.90033 11.5399 7.82946V3.24065ZM13.4599 5.79912V9.4718C9.01296 10.7177 5.9753 12.8573 4.494 17.4678C7.12663 15.6288 10.0927 14.5312 13.4599 14.04V18.2056L21.1035 12.0023L13.4599 5.79912Z"
        fill="#361600"
      />
    </svg>
  );
});
