import React, { SVGAttributes, forwardRef } from 'react';

export interface SocialProvidersProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const SocialProviders = forwardRef<SVGSVGElement, SocialProvidersProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M7.69624 1.76025C8.09257 1.28482 8.29141 0.771165 8.29141 0.221039C8.29141 0.148075 8.28805 0.0745198 8.27999 0.000976562C8.0039 0.0154549 7.71034 0.100002 7.4 0.252884C7.08898 0.408081 6.8325 0.602633 6.63085 0.836613C6.22692 1.29873 5.99947 1.86393 5.99947 2.39205C5.99947 2.46504 6.00411 2.5345 6.0121 2.6005C6.63944 2.65203 7.21795 2.32544 7.69624 1.76025ZM10.3913 8.57332C10.2267 8.95763 10.0319 9.31138 9.8062 9.63662C9.49854 10.08 9.24664 10.3869 9.0525 10.5573C8.75156 10.8371 8.42912 10.9803 8.08384 10.9885C7.83597 10.9885 7.53704 10.9172 7.18908 10.7726C6.83997 10.6286 6.51914 10.5573 6.22579 10.5573C5.91813 10.5573 5.58817 10.6286 5.23523 10.7726C4.88176 10.9172 4.597 10.9926 4.37929 11C4.04818 11.0143 3.71816 10.867 3.38873 10.5573C3.17847 10.372 2.91548 10.0542 2.60043 9.60403C2.26241 9.1233 1.98451 8.56585 1.7668 7.93031C1.53363 7.24385 1.41675 6.57912 1.41675 5.93557C1.41675 5.19839 1.57434 4.56258 1.88999 4.02978C2.13807 3.60181 2.4681 3.26421 2.88116 3.01638C3.29422 2.76855 3.74052 2.64226 4.22116 2.63418C4.48415 2.63418 4.82903 2.7164 5.2576 2.878C5.68497 3.04015 5.95937 3.12237 6.07968 3.12237C6.16963 3.12237 6.47447 3.02623 6.99125 2.83455C7.47994 2.65679 7.8924 2.58318 8.23028 2.61218C9.14588 2.68687 9.83375 3.05169 10.2912 3.70895C9.47235 4.21046 9.06728 4.91287 9.07534 5.81396C9.08273 6.51584 9.33464 7.09991 9.82972 7.56366C10.0541 7.7789 10.3046 7.94525 10.5834 8.0634C10.523 8.24061 10.4591 8.41036 10.3913 8.57332ZM13.0001 6.32098C13.0001 4.2845 13.0001 3.26628 13.6327 2.63363C14.2654 2.00098 15.2836 2.00098 17.3201 2.00098H17.6801C19.7166 2.00098 20.7348 2.00098 21.3674 2.63363C22.0001 3.26628 22.0001 4.2845 22.0001 6.32098V6.68098C22.0001 8.71745 22.0001 9.73567 21.3674 10.3683C20.7348 11.001 19.7166 11.001 17.6801 11.001H17.3201C15.2836 11.001 14.2654 11.001 13.6327 10.3683C13.0001 9.73567 13.0001 8.71745 13.0001 6.68098V6.32098ZM17.7888 8.48475C15.7376 8.48475 14.5676 7.0785 14.5189 4.7385H15.5464C15.5801 6.456 16.3376 7.1835 16.9376 7.3335V4.7385H17.9051V6.21975C18.4976 6.156 19.1201 5.481 19.3301 4.7385H20.2976C20.1363 5.6535 19.4613 6.3285 18.9813 6.606C19.4613 6.831 20.2301 7.41975 20.5226 8.48475H19.4576C19.2288 7.77225 18.6589 7.221 17.9051 7.146V8.48475H17.7888ZM17.5 13.001C18.5918 13.001 19.5929 13.3899 20.3722 14.037L18.9145 15.2306C18.5043 14.9742 18.0195 14.8261 17.5 14.8261C16.0229 14.8261 14.825 16.0232 14.825 17.5013C14.8252 18.9785 16.0227 20.1762 17.4999 20.1762C18.6472 20.1762 19.6254 19.4544 20.0052 18.4407H17.599V16.6604H21.9213C22.0327 17.2472 22.0258 17.8566 21.9015 18.4407C21.4504 20.5651 19.6901 22.001 17.4998 22.001C15.0147 22.001 13.0001 19.9868 13.0001 17.5013C13.0001 15.0163 15.0144 13.001 17.5 13.001ZM6.50008 13.001C8.98536 13.001 11.0001 15.0157 11.0001 17.501C11.0001 19.747 9.3545 21.6087 7.2032 21.9463V18.8018H8.25164L8.25165 18.8018H8.25174L8.45125 17.501H7.2032V16.6572C7.2032 16.523 7.22797 16.3901 7.28875 16.2765C7.38928 16.0889 7.58825 15.9541 7.93647 15.9541H8.50389V15.9541H8.50398V14.8467C8.50398 14.8467 7.98886 14.7588 7.49667 14.7588C7.33606 14.7588 7.18415 14.774 7.04213 14.804C6.99997 14.8129 6.95868 14.8231 6.9183 14.8345C6.22404 15.032 5.79686 15.6103 5.79686 16.5096V17.501H4.65437V17.501H4.65428V18.8018H5.79686V21.9463C3.6456 21.6087 2.00008 19.747 2.00008 17.501C2.00008 15.0157 4.01479 13.001 6.50008 13.001Z"
        fill="currentColor"
      />
    </svg>
  );
});
