import React, { SVGAttributes, forwardRef } from 'react';

export interface SyncProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Sync = forwardRef<SVGSVGElement, SyncProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M20.5641 7.97494C20.7589 8.46722 20.3962 9.00092 19.8667 9.00092H14.8148C14.2131 9.00092 13.8564 8.32804 14.194 7.83004L15.2025 6.34267C14.2445 5.79981 13.1474 5.50092 12.0001 5.50092C8.89621 5.50092 6.24205 7.69358 5.63085 10.6966C5.5207 11.2378 4.99269 11.5872 4.4515 11.477C3.91031 11.3669 3.56088 10.8389 3.67103 10.2977C4.47095 6.36743 7.9408 3.50092 12.0001 3.50092C13.5557 3.50092 15.042 3.92206 16.3276 4.68319L17.384 3.12512C17.7221 2.62645 18.4805 2.70982 18.7022 3.27002L20.5641 7.97494ZM7.67265 19.3187L6.61626 20.8767C6.27816 21.3754 5.51981 21.292 5.29811 20.7318L3.43617 16.0269C3.24135 15.5346 3.60412 15.0009 4.13354 15.0009H9.18549C9.78717 15.0009 10.1439 15.6738 9.80626 16.1718L8.7978 17.6592C9.75582 18.202 10.8529 18.5009 12.0001 18.5009C15.1069 18.5009 17.7628 16.3043 18.371 13.2977C18.4805 12.7564 19.0081 12.4063 19.5494 12.5158C20.0907 12.6253 20.4408 13.1529 20.3313 13.6942C19.5353 17.6292 16.0632 20.5009 12.0001 20.5009C10.4445 20.5009 8.95827 20.0798 7.67265 19.3187Z"
        fill="currentColor"
      />
    </svg>
  );
});
