import React, { SVGAttributes, forwardRef } from 'react';

export interface YandexProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
}

export const Yandex = forwardRef<SVGSVGElement, YandexProps>((props, ref) => {
  const { className, ...otherProps } = props;

  return (
    <svg
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <circle cx="12" cy="12" r="12" fill="#FC3F1D" />
      <path
        d="M13.7695 6.72045H12.555C10.4731 6.72045 9.43215 7.76141 9.43215 9.32286C9.43215 11.0578 10.1261 11.9253 11.6876 12.9662L12.902 13.8337L9.43215 19.212H6.65625L9.95264 14.3542C8.0442 12.9662 7.00324 11.7518 7.00324 9.49635C7.00324 6.72045 8.91167 4.81201 12.555 4.81201H16.1984V19.212H13.7695V6.72045Z"
        fill="white"
      />
    </svg>
  );
});
