import { Meta } from '@storybook/react';

import * as icons from '../index';

import styles from './styles.module.css';

export default {
  title: 'icons',
} as Meta;

export const Default = () => {
  return (
    <div className={styles.grid}>
      {Object.entries(icons).map(([name, Icon]) => (
        <div className={styles.item} key={name}>
          <Icon />
          <div className={styles.caption}>{name}</div>
        </div>
      ))}
    </div>
  );
};
