import React, { SVGAttributes, forwardRef } from 'react';

import { useUniqId } from '@use-platform/react';

export interface AndroidProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Android = forwardRef<SVGSVGElement, AndroidProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;
  const id = useUniqId();

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        d="M12.002 2.03s5.878-.263 8.995 5.625h-9.495S9.71 7.597 8.179 9.763c-.44.91-.912 1.846-.382 3.692-.764-1.29-4.056-7.002-4.056-7.002S6.063 2.263 12 2.03Z"
        fill="#EF3F36"
      />
      <path
        d="M20.692 16.976s-2.713 5.206-9.385 4.949l4.748-8.194s.949-1.517-.17-3.921c-.569-.835-1.149-1.709-3.017-2.175 1.503-.013 8.112 0 8.112 0s2.476 4.1-.288 9.341Z"
        fill="#FCD900"
      />
      <path
        d="M3.353 17.017s-3.169-4.942.393-10.573c.822 1.422 4.746 8.194 4.746 8.194s.847 1.577 3.493 1.813c1.009-.074 2.059-.137 3.4-1.515-.74 1.304-4.057 7-4.057 7s-4.804.087-7.975-4.919Z"
        fill="#61BC5B"
      />
      <path
        d="m11.304 21.974 1.335-5.554s1.468-.115 2.7-1.46c-.765 1.34-4.035 7.014-4.035 7.014Z"
        fill="#5AB055"
      />
      <path
        d="M7.528 12.063c0-2.448 1.992-4.433 4.45-4.433 2.456 0 4.449 1.985 4.449 4.433 0 2.449-1.993 4.434-4.45 4.434-2.457-.003-4.45-1.985-4.45-4.434Z"
        fill="#fff"
      />
      <path
        d="M8.272 12.064a3.698 3.698 0 0 1 3.705-3.692 3.698 3.698 0 0 1 3.705 3.692 3.698 3.698 0 0 1-3.705 3.691 3.7 3.7 0 0 1-3.705-3.691Z"
        fill={`url(#${id}1pqfby7_a)`}
      />
      <path
        d="m20.977 7.638-5.499 1.608s-.83-1.213-2.613-1.608c1.547-.008 8.112 0 8.112 0Z"
        fill="#EACA05"
      />
      <path
        d="M7.69 13.252c-.772-1.334-3.95-6.8-3.95-6.8l4.074 4.015s-.418.857-.261 2.084l.137.701Z"
        fill="#DF3A32"
      />
      <defs>
        <linearGradient
          id={`${id}1pqfby7_a`}
          x1={11.977}
          y1={8.424}
          x2={11.977}
          y2={15.533}
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#86BBE5" />
          <stop offset={1} stopColor="#1072BA" />
        </linearGradient>
      </defs>
    </svg>
  );
});
