import { FC, RefAttributes, SVGAttributes, forwardRef } from 'react';

import { Android } from './android';
import { Chrome } from './chrome';
import { ChromeMobile } from './chrome-mobile';
import { Chromium } from './chromium';
import { Edge } from './edge';
import { Firefox } from './firefox';
import { FirefoxMobile } from './firefox-mobile';
import { Msie } from './msie';
import { Opera } from './opera';
import { OperaMobile } from './opera-mobile';
import { Safari } from './safari';
import { SafariMobile } from './safari-mobile';
import { SamsungInternet } from './samsung-internet';
import { Tor } from './tor';
import { Yandex } from './yandex';
import { YandexLite } from './yandex-lite';

export type BrowserName =
  | 'android'
  | 'chrome'
  | 'chrome-mobile'
  | 'chromium'
  | 'edge'
  | 'firefox'
  | 'firefox-mobile'
  | 'msie'
  | 'opera'
  | 'opera-mobile'
  | 'safari'
  | 'safari-mobile'
  | 'samsung-internet'
  | 'tor'
  | 'yandex-lite'
  | 'yandex';

const BROWSER_MAP: Record<
  BrowserName,
  FC<Omit<BrowserProps, 'name'> & RefAttributes<SVGSVGElement>>
> = {
  android: Android,
  chrome: Chrome,
  'chrome-mobile': ChromeMobile,
  chromium: Chromium,
  edge: Edge,
  firefox: Firefox,
  'firefox-mobile': FirefoxMobile,
  msie: Msie,
  opera: Opera,
  'opera-mobile': OperaMobile,
  safari: Safari,
  'safari-mobile': SafariMobile,
  'samsung-internet': SamsungInternet,
  tor: Tor,
  'yandex-lite': YandexLite,
  yandex: Yandex,
};

export interface BrowserProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;

  name: BrowserName;
}

export const Browser = forwardRef<SVGSVGElement, BrowserProps>((props, ref) => {
  const { name, ...otherProps } = props;

  const Icon = BROWSER_MAP[name];

  return <Icon ref={ref} {...otherProps} />;
});
