import React, { SVGAttributes, forwardRef } from 'react';

import { useUniqId } from '@use-platform/react';

export interface EdgeProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Edge = forwardRef<SVGSVGElement, EdgeProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;
  const id = useUniqId();

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        d="M14.566 11.912c0-1.91-1.985-5.205-6.454-5.205C3.642 6.707 2 10.435 2 12.025 2 6.344 6.63 2.003 12.125 2.003c5.496 0 9.875 4.113 9.875 8.295 0 3.727-2.805 5.023-5.085 5.023-1.506 0-3.216-.5-3.216-1.296 0-.613.867-.613.867-2.113Z"
        fill={`url(#${id}1x6zvji_a)`}
      />
      <path
        d="M8.112 6.707c4.47 0 6.454 3.296 6.454 5.205v.044c-.023-1.271-.882-2.476-2.577-2.476-2.144 0-5.04 2.91-4.653 6.523.31 2.892 2.76 6.773 8.073 5.409 0 0-1.003.59-3.808.59-4.972 0-9.601-4.545-9.601-9.75 0-.137.002-.272.006-.405.115-1.674 1.796-5.14 6.106-5.14Z"
        fill={`url(#${id}1x6zvji_b)`}
      />
      <path
        d="M8.112 6.707c4.47 0 6.454 3.296 6.454 5.205v.044c-.023-1.271-.882-2.476-2.577-2.476-2.144 0-5.04 2.91-4.653 6.523.31 2.892 2.76 6.773 8.073 5.409 0 0-1.003.59-3.808.59-4.972 0-9.601-4.545-9.601-9.75 0-.137.002-.272.006-.405.115-1.674 1.796-5.14 6.106-5.14Z"
        fill={`url(#${id}1x6zvji_c)`}
      />
      <path
        d="M14.79 21.645c2.847-.776 4.881-3.199 5.249-3.688.41-.545.524-.886.41-1-.114-.113-.273-.09-.684.114-.41.204-2.828 1.204-5.587.363-2.76-.84-4.652-3.022-4.652-5.431 0-1.864 1.596-2.523 2.463-2.523-2.144 0-5.04 2.91-4.653 6.523.31 2.892 2.76 6.772 8.073 5.409 0 0-.185.109-.619.233Z"
        fill="#0E458A"
      />
      <path
        d="M14.79 21.645c2.847-.776 4.881-3.199 5.249-3.688.41-.545.524-.886.41-1-.114-.113-.273-.09-.684.114-.41.204-2.828 1.204-5.587.363-2.76-.84-4.652-3.022-4.652-5.431 0-1.864 1.596-2.523 2.463-2.523-2.144 0-5.04 2.91-4.653 6.523.31 2.892 2.76 6.772 8.073 5.409 0 0-.185.109-.619.233Z"
        fill={`url(#${id}1x6zvji_d)`}
      />
      <defs>
        <radialGradient
          id={`${id}1x6zvji_c`}
          cx={0}
          cy={0}
          r={1}
          gradientUnits="userSpaceOnUse"
          gradientTransform="rotate(59.214 -8.248 14.448) scale(6.77251 6.78356)"
        >
          <stop stopColor="#1284D8" />
          <stop offset={0.814} stopColor="#1170B2" stopOpacity={0.768} />
          <stop offset={1} stopColor="#0E649B" stopOpacity={0.65} />
        </radialGradient>
        <radialGradient
          id={`${id}1x6zvji_d`}
          cx={0}
          cy={0}
          r={1}
          gradientUnits="userSpaceOnUse"
          gradientTransform="matrix(1.14025 5.36364 -5.79076 1.23105 13.904 16.003)"
        >
          <stop stopColor="#104890" />
          <stop offset={0.699} stopColor="#12529E" stopOpacity={0.706} />
          <stop offset={1} stopColor="#0E4584" stopOpacity={0.58} />
        </radialGradient>
        <linearGradient
          id={`${id}1x6zvji_a`}
          x1={20.837}
          y1={13.821}
          x2={1.277}
          y2={9.2}
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#3BCC50" />
          <stop offset={0.49} stopColor="#2ABAD6" />
          <stop offset={1} stopColor="#7DCFE7" />
        </linearGradient>
        <linearGradient
          id={`${id}1x6zvji_b`}
          x1={8.705}
          y1={6.707}
          x2={8.705}
          y2={22.003}
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#035989" />
          <stop offset={0.266} stopColor="#1175B6" />
          <stop offset={1} stopColor="#0470CF" />
        </linearGradient>
      </defs>
    </svg>
  );
});
