import React, { SVGAttributes, forwardRef } from 'react';

export interface MsieProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Msie = forwardRef<SVGSVGElement, MsieProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        d="M20.875 8.04C23.93.99 17.6 2.021 17.247 2.091a15.886 15.886 0 0 0-3.727 1.241c-4.362-.25-8.318 2.847-9.273 7.093C6.5 7.852 8.075 6.813 9.018 6.397c-2.77 2.527-5.511 5.831-6.521 9.509-2.54 9.248 5.423 5.382 6.537 4.795a8.814 8.814 0 0 0 3.977.943c3.909 0 7.235-2.543 8.473-6.095H16.76c-.7 1.204-2.045 2.02-3.59 2.02-2.266 0-4.102-1.75-4.102-3.908h12.859a9.361 9.361 0 0 0-1.052-5.622Zm-.554-4.576c.775.533 1.395 1.37.33 4.186a9.062 9.062 0 0 0-4.391-3.714c.832-.41 2.892-1.276 4.061-.472ZM3.87 20.682c-.631-.66-.742-2.264.65-5.19a9.153 9.153 0 0 0 3.914 4.877c-.901.505-3.292 1.643-4.564.313Zm5.18-9.526C9.12 9.059 10.91 7.38 13.11 7.38s3.99 1.679 4.063 3.776H9.048Z"
        fill="#1EBBEE"
      />
    </svg>
  );
});
