import React, { SVGAttributes, forwardRef } from 'react';

import { useUniqId } from '@use-platform/react';

export interface OperaMobileProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const OperaMobile = forwardRef<SVGSVGElement, OperaMobileProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;
  const id = useUniqId();

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        d="M8.71 17.633c-1.108-1.305-1.82-3.235-1.866-5.399v-.468c.047-2.164.765-4.094 1.867-5.399 1.437-1.86 3.547-2.695 5.93-2.695 1.468 0 2.851.101 4.023.883A9.895 9.895 0 0 0 12.04 2H12C6.477 2 2 6.477 2 12c0 5.36 4.219 9.742 9.523 9.992.157.008.32.008.477.008 2.563 0 4.898-.96 6.664-2.547-1.172.781-2.477.813-3.945.813-2.375.007-4.578-.766-6.008-2.633Z"
        fill={`url(#${id}11o2hr9_a)`}
      />
      <path
        d="M8.71 6.367c.915-1.086 2.102-1.734 3.4-1.734 2.913 0 5.273 3.297 5.273 7.375 0 4.078-2.36 7.375-5.274 7.375-1.296 0-2.476-.656-3.398-1.735 1.437 1.86 3.57 3.047 5.945 3.047a7.197 7.197 0 0 0 4.008-1.226A10.029 10.029 0 0 0 22 12a9.97 9.97 0 0 0-3.336-7.453 7.178 7.178 0 0 0-4.008-1.227c-2.383 0-4.515 1.18-5.945 3.047Z"
        fill={`url(#${id}11o2hr9_b)`}
      />
      <defs>
        <linearGradient
          id={`${id}11o2hr9_a`}
          x1={10.332}
          y1={2.326}
          x2={10.332}
          y2={21.709}
          gradientUnits="userSpaceOnUse"
        >
          <stop offset={0.3} stopColor="#FF1B2D" />
          <stop offset={0.438} stopColor="#FA1A2C" />
          <stop offset={0.594} stopColor="#ED1528" />
          <stop offset={0.758} stopColor="#D60E21" />
          <stop offset={0.927} stopColor="#B70519" />
          <stop offset={1} stopColor="#A70014" />
        </linearGradient>
        <linearGradient
          id={`${id}11o2hr9_b`}
          x1={15.354}
          y1={3.469}
          x2={15.354}
          y2={20.612}
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#9C0000" />
          <stop offset={0.7} stopColor="#FF4B4B" />
        </linearGradient>
      </defs>
    </svg>
  );
});
