import React, { SVGAttributes, forwardRef } from 'react';

export interface SamsungInternetProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const SamsungInternet = forwardRef<SVGSVGElement, SamsungInternetProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        d="M21.821 9.017c-.247-1.858-.904-3.54-2.06-4.774-1.234-1.156-2.918-1.813-4.776-2.06-1.774-.235-2.983-.178-2.983-.178s-1.209-.057-2.982.178c-1.858.247-3.542.904-4.772 2.06-1.16 1.233-1.817 2.916-2.065 4.774-.235 1.772-.178 2.981-.178 2.981s-.057 1.209.178 2.981c.248 1.858.905 3.54 2.061 4.774 1.234 1.16 2.918 1.817 4.772 2.064 1.773.235 2.982.178 2.982.178s1.21.057 2.982-.178c1.859-.247 3.543-.904 4.772-2.064 1.16-1.233 1.818-2.916 2.061-4.774.236-1.772.179-2.981.179-2.981s.065-1.209-.17-2.981Z"
        fill="#7882FF"
      />
      <path
        d="M17.123 10.521A5.342 5.342 0 0 1 13.41 17.1a5.342 5.342 0 0 1-6.577-3.713 5.342 5.342 0 0 1 3.713-6.577 5.342 5.342 0 0 1 6.577 3.712Z"
        fill="#fff"
      />
      <path
        d="M17.052 13.618a.107.107 0 0 1-.006.032c-.045.113-.479.365-1.493.365-1.132 0-2.605-.313-4.034-.856-1.428-.54-2.734-1.287-3.582-2.037-.759-.674-.921-1.153-.877-1.266a.121.121 0 0 1 .022-.034c.34-.781.866-1.479 1.539-2.023h-.072c-2.19 0-2.864.913-3.071 1.456-.207.544-.308 1.672 1.33 3.129 1.011.896 2.468 1.732 4.107 2.353 1.64.62 3.283.966 4.634.966 2.195 0 2.868-.913 3.071-1.457.207-.544.308-1.672-1.33-3.128l-.042-.037a5.3 5.3 0 0 1-.196 2.537Z"
        fill="#4D5CC1"
      />
    </svg>
  );
});
