import React, { SVGAttributes, forwardRef } from 'react';

export interface TorProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Tor = forwardRef<SVGSVGElement, TorProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        d="M2 12C2 6.477 6.477 2 12 2s10 4.477 10 10-4.477 10-10 10S2 17.523 2 12Z"
        fill="#59316B"
      />
      <path
        d="m12.739 4.602-.408 1.66c.578-1.173 1.496-2.055 2.55-2.834-.771.918-1.474 1.836-1.904 2.753.725-1.045 1.7-1.626 2.799-2.01a19.643 19.643 0 0 0-3.506 4.21l-.703-.314c.124-1.15.548-2.327 1.172-3.465Z"
        fill="#ABCD03"
      />
      <path
        d="m10.862 7.762 1.338.569c0 .348-.028 1.411.185 1.725 2.224 2.935 1.85 8.82-.451 8.97-3.503 0-4.84-2.439-4.84-4.68 0-2.044 2.392-3.403 3.82-4.611.363-.325.3-1.044-.052-1.973Z"
        fill="#FFFCDB"
      />
      <path
        d="m12.2 8.31.482.252c-.045.325.023 1.045.34 1.231 1.405.894 2.731 1.87 3.253 2.846 1.858 3.438-1.304 6.62-4.035 6.318 1.485-1.127 1.915-3.438 1.36-5.958-.226-.988-.578-1.882-1.201-2.892-.27-.496-.176-1.112-.199-1.797Z"
        fill="#fff"
      />
      <path
        d="m11.968 8.225.997.14c-.294.998.578 1.695.862 1.858.634.36 1.246.732 1.734 1.184A4.572 4.572 0 0 1 17 14.753a4.367 4.367 0 0 1-1.519 3.299c-.895.767-2.13 1.092-3.332 1.092-.748 0-1.416-.035-2.142-.28-1.654-.568-2.89-2.02-2.992-3.762-.09-1.36.204-2.393 1.236-3.473.532-.569 1.61-1.22 2.346-1.742.363-.256.748-.976.011-2.335l.147-.116 1.092.75-.921-.39c.079.117.294.64.34.79.102.43.056.848-.034 1.034-.465.86-1.258 1.092-1.836 1.58-1.02.859-2.131 1.544-2.006 3.902.056 1.161.94 2.578 2.266 3.24.748.372 1.61.523 2.482.57.782.034 2.278-.442 3.094-1.139.873-.743 1.36-1.87 1.36-3.02 0-1.161-.453-2.264-1.303-3.043-.487-.452-1.292-.998-1.79-1.289-.5-.29-1.123-1.103-.919-1.881l-.612-.314Z"
        fill="#000"
      />
      <path
        d="M11.662 9.944c-.102.534-.215 1.498-.669 1.858-.192.14-.385.28-.589.418-.816.57-1.632 1.104-2.006 2.474-.08.29-.011.604.057.895.204.836.782 1.742 1.235 2.276 0 .023.09.081.09.105.375.453.488.58 1.905.905l-.034.163c-.85-.232-1.553-.441-1.995-.964 0-.011-.08-.093-.08-.093-.475-.557-1.053-1.486-1.269-2.358-.079-.348-.147-.615-.056-.975.385-1.417 1.224-1.975 2.074-2.567.192-.128.419-.244.6-.395.352-.267.544-1.08.737-1.742Z"
        fill="#000"
      />
      <path
        d="M12.024 12.15c.012.605-.046.908.102 1.338.09.255.396.604.487.94.125.453.26.953.25 1.255 0 .348-.022.998-.17 1.695-.112.576-.37 1.07-.806 1.35-.446-.094-.97-.254-1.278-.526-.601-.534-1.133-1.427-1.201-2.206-.057-.638.52-1.58 1.325-2.057.68-.406.838-.87.986-1.613-.204.65-.396 1.196-1.053 1.544-.952.511-1.44 1.37-1.396 2.182.068 1.045.477 1.754 1.282 2.323.34.244.975.502 1.371.571v-.053c.301-.058.69-.564.885-1.249.17-.615.237-1.403.225-1.903-.011-.29-.136-.919-.363-1.488-.124-.313-.316-.627-.44-.848-.136-.22-.138-.697-.206-1.254Z"
        fill="#000"
      />
      <path
        d="M11.957 14.428c.011.407.17.928.238 1.462.057.395.032.791.021 1.14-.011.403-.142 1.126-.321 1.478-.17-.08-.236-.17-.345-.317a2.947 2.947 0 0 1-.32-.627c-.067-.174-.147-.373-.18-.606a2.04 2.04 0 0 1 .352-1.45c.295-.442.362-.476.464-.987-.136.453-.237.5-.555.883-.351.418-.41 1.034-.41 1.533 0 .21.082.441.161.662.09.232.168.463.293.637.188.283.427.444.545.474h.002l.008.002V18.7c.22-.251.352-.5.397-.752.057-.302.07-.605.104-.965.034-.302.009-.709-.07-1.127-.114-.522-.305-1.055-.384-1.427Z"
        fill="#000"
      />
      <path
        d="M11.99 9.456c.012.604.057 1.73.216 2.172.045.151.465.813.76 1.614.203.558.248 1.07.283 1.22.135.662-.035 1.777-.261 2.834-.114.57-.499 1.277-.94 1.556l-.091.163c.249-.012.86-.627 1.076-1.394.363-1.3.51-1.905.34-3.345-.022-.14-.08-.615-.294-1.126-.318-.779-.771-1.522-.828-1.673-.102-.244-.238-1.3-.26-2.02Z"
        fill="#000"
      />
      <path
        d="M12.203 8.63c-.033.621-.042.85.071 1.303.125.499.76 1.219 1.02 2.044.499 1.58.374 3.647.011 5.26-.136.57-.782 1.395-1.428 1.662l.476.116c.261-.012.93-.65 1.19-1.382.42-1.15.5-2.52.329-3.96-.011-.14-.238-1.383-.453-1.905-.306-.779-.85-1.476-.907-1.626-.102-.256-.326-.786-.309-1.512Z"
        fill="#000"
      />
      <path fill="#000" d="M11.843 8.194h.351v10.717h-.351z" />
    </svg>
  );
});
