import React, { SVGAttributes, forwardRef } from 'react';

export interface YandexProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Icon size
   *
   * @default 24
   */
  size?: 12 | 16 | 24 | 32;
}

export const Yandex = forwardRef<SVGSVGElement, YandexProps>((props, ref) => {
  const { className, size = 24, ...otherProps } = props;

  return (
    <svg
      width={size}
      height={size}
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <path
        d="M2 12C2 6.477 6.477 2 12 2s10 4.477 10 10-4.477 10-10 10S2 17.523 2 12Z"
        fill="#fff"
      />
      <path
        d="m6.654 6.871-.099.127a1 1 0 0 0 .097 1.337L11 12.5V19h2v-6.5l4.348-4.165a1 1 0 0 0 .097-1.337l-.1-.127a1 1 0 0 0-1.478-.109L12 10.447 8.133 6.762a1 1 0 0 0-1.479.11Z"
        fill="#FF0013"
      />
    </svg>
  );
});
