import React, { SVGAttributes, forwardRef } from 'react';

import { useUniqId } from '@use-platform/react';

export interface AlisaProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
}

export const Alisa = forwardRef<SVGSVGElement, AlisaProps>((props, ref) => {
  const { className, ...otherProps } = props;
  const id = useUniqId();

  return (
    <svg
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={'SvgIcon' + (className ? ' ' + className : '')}
      ref={ref}
    >
      <circle cx="11.999" cy="12.001" r="12" fill={`url(#${id}paint0_linear_2179_31703)`} />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M6.28224 16.1941C7.18198 17.0821 9.5792 17.614 12.0226 17.6239C14.466 17.614 16.8632 17.0821 17.7617 16.1941C19.998 13.99 14.5633 5.54118 12.0251 5.52881C9.48062 5.54118 4.04599 13.99 6.28224 16.1941Z"
        fill="white"
      />
      <defs>
        <linearGradient
          id={`${id}paint0_linear_2179_31703`}
          x1="19.7769"
          y1="30.3581"
          x2="30.1312"
          y2="4.50078"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#C826FF" />
          <stop offset="1" stopColor="#5426FF" />
        </linearGradient>
      </defs>
    </svg>
  );
});
